/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.engine.FormEngine;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class GetRenderedTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String formEngineName;

    public GetRenderedTaskFormCmd(String taskId, String formEngineName) {
        this.taskId = taskId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("Task '" + this.taskId + "' not found");
        }
        if (task.getTaskDefinition() == null) {
            throw new ProcessEngineException("Task form definition for '" + this.taskId + "' not found");
        }
        TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
        if (taskFormHandler == null) {
            return null;
        }
        FormEngine formEngine = Context.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
        if (formEngine == null) {
            throw new ProcessEngineException("No formEngine '" + this.formEngineName + "' defined process engine configuration");
        }
        TaskFormData taskForm = taskFormHandler.createTaskForm(task);
        return formEngine.renderTaskForm(taskForm);
    }
}

