/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.DefaultFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;

public class GetFormKeyCmd
implements Command<String> {
    protected String taskDefinitionKey;
    protected String processDefinitionId;

    public GetFormKeyCmd(String processDefinitionId) {
        this.setProcessDefinitionId(processDefinitionId);
    }

    public GetFormKeyCmd(String processDefinitionId, String taskDefinitionKey) {
        this.setProcessDefinitionId(processDefinitionId);
        if (taskDefinitionKey == null || taskDefinitionKey.length() < 1) {
            throw new ProcessEngineException("The task definition key is mandatory, but '" + taskDefinitionKey + "' has been provided.");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    protected void setProcessDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        DefaultFormHandler formHandler;
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (this.taskDefinitionKey == null) {
            formHandler = (DefaultFormHandler)((Object)processDefinition.getStartFormHandler());
        } else {
            TaskDefinition taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
            formHandler = (DefaultFormHandler)((Object)taskDefinition.getTaskFormHandler());
        }
        String formKey = null;
        if (formHandler.getFormKey() != null) {
            formKey = formHandler.getFormKey().getExpressionText();
        }
        return formKey;
    }
}

