/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class GetDeploymentBpmnModelInstanceCmd
implements Command<BpmnModelInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentBpmnModelInstanceCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public BpmnModelInstance execute(CommandContext commandContext) {
        BpmnModelInstance modelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        if (modelInstance == null) {
            throw new ProcessEngineException("no BPMN model instance found for process definition id " + this.processDefinitionId);
        }
        return modelInstance;
    }
}

