/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.InputStream;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.task.Attachment;

public class CreateAttachmentCmd
implements Command<Attachment> {
    protected String taskId;
    protected String attachmentType;
    protected String processInstanceId;
    protected String attachmentName;
    protected String attachmentDescription;
    protected InputStream content;
    protected String url;
    private TaskEntity task;

    public CreateAttachmentCmd(String attachmentType, String taskId, String processInstanceId, String attachmentName, String attachmentDescription, InputStream content, String url) {
        this.attachmentType = attachmentType;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.attachmentName = attachmentName;
        this.attachmentDescription = attachmentDescription;
        this.content = content;
        this.url = url;
    }

    @Override
    public Attachment execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        this.task = commandContext.getTaskManager().findTaskById(this.taskId);
        AttachmentEntity attachment = new AttachmentEntity();
        attachment.setName(this.attachmentName);
        attachment.setDescription(this.attachmentDescription);
        attachment.setType(this.attachmentType);
        attachment.setTaskId(this.taskId);
        attachment.setProcessInstanceId(this.processInstanceId);
        attachment.setUrl(this.url);
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.insert(attachment);
        if (this.content != null) {
            byte[] bytes = IoUtil.readInputStream(this.content, this.attachmentName);
            ByteArrayEntity byteArray = new ByteArrayEntity(bytes);
            dbSqlSession.insert(byteArray);
            attachment.setContentId(byteArray.getId());
        }
        PropertyChange propertyChange = new PropertyChange("name", null, this.attachmentName);
        commandContext.getOperationLogManager().logAttachmentOperation("AddAttachment", this.task, propertyChange);
        return attachment;
    }
}

