/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.tomcat.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.camunda.bpm.container.impl.jmx.deployment.AbstractParseBpmPlatformXmlStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.engine.ProcessEngineException;

public class TomcatParseBpmPlatformXmlStep
extends AbstractParseBpmPlatformXmlStep {
    public static final String CATALINA_BASE = "catalina.base";
    public static final String CATALINA_HOME = "catalina.home";

    @Override
    protected URL getBpmPlatformXmlStream(MBeanDeploymentOperation operationcontext) {
        URL fileLocation = this.lookupBpmPlatformXml();
        if (fileLocation == null) {
            fileLocation = this.lookupBpmPlatformXmlFromCatalinaConfDirectory();
        }
        return fileLocation;
    }

    public URL lookupBpmPlatformXmlFromCatalinaConfDirectory() {
        String catalinaHome = System.getProperty(CATALINA_BASE);
        if (catalinaHome == null) {
            catalinaHome = System.getProperty(CATALINA_HOME);
        }
        String bpmPlatformFileLocation = catalinaHome + File.separator + "conf" + File.separator + "bpm-platform.xml";
        try {
            URL fileLocation = this.checkValidFileLocation(bpmPlatformFileLocation);
            if (fileLocation != null) {
                this.LOGGER.log(Level.INFO, "Found camunda bpm platform configuration in CATALINA_BASE/CATALINA_HOME conf directory [" + bpmPlatformFileLocation + "] at " + fileLocation.toString());
            }
            return fileLocation;
        }
        catch (MalformedURLException e) {
            throw new ProcessEngineException("'" + bpmPlatformFileLocation + "' is not a valid camunda bpm platform configuration resource location.", e);
        }
    }
}

