/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.engine.ProcessEngineException;

public class MBeanDeploymentOperation {
    protected Logger log = Logger.getLogger(MBeanDeploymentOperation.class.getName());
    protected final String name;
    protected final MBeanServiceContainer serviceContainer;
    protected final List<MBeanDeploymentOperationStep> steps;
    protected final List<MBeanDeploymentOperationStep> successfulSteps = new ArrayList<MBeanDeploymentOperationStep>();
    protected List<ObjectName> installedServices = new ArrayList<ObjectName>();
    protected Map<String, Object> attachments = new HashMap<String, Object>();
    protected boolean isRollbackOnFailure = true;
    protected MBeanDeploymentOperationStep currentStep;

    public MBeanDeploymentOperation(String name, MBeanServiceContainer container, List<MBeanDeploymentOperationStep> steps) {
        this.name = name;
        this.serviceContainer = container;
        this.steps = steps;
    }

    public <S> S getAttachment(String name) {
        return (S)this.attachments.get(name);
    }

    public void addAttachment(String name, Object value) {
        this.attachments.put(name, value);
    }

    public void addStep(MBeanDeploymentOperationStep step) {
        if (this.currentStep != null) {
            this.steps.add(this.steps.indexOf(this.currentStep) + 1, step);
        } else {
            this.steps.add(step);
        }
    }

    void serviceAdded(ObjectName serviceName) {
        this.installedServices.add(serviceName);
    }

    public MBeanServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public void execute() {
        while (!this.steps.isEmpty()) {
            this.currentStep = this.steps.remove(0);
            try {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Performing operation step: '" + this.currentStep.getName() + "'");
                }
                this.currentStep.performOperationStep(this);
                this.successfulSteps.add(this.currentStep);
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine("Successfully performed operation step: '" + this.currentStep.getName() + "'");
            }
            catch (Exception e) {
                if (this.isRollbackOnFailure) {
                    try {
                        this.rollbackOperation();
                    }
                    catch (Exception e2) {
                        this.log.log(Level.SEVERE, "Exception while rolling back operation " + e2.getMessage(), e2);
                    }
                    throw new ProcessEngineException("Exception while performing '" + this.name + " => " + this.currentStep.getName() + "': " + e.getMessage(), e);
                }
                this.log.log(Level.SEVERE, "Exception while performing operation step '" + this.currentStep.getName() + "': " + e.getMessage(), e);
            }
        }
    }

    protected void rollbackOperation() {
        for (MBeanDeploymentOperationStep step : this.successfulSteps) {
            try {
                step.cancelOperationStep(this);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Exception while cancelling '" + step.getName() + "'", e);
            }
        }
        for (ObjectName serviceName : this.installedServices) {
            try {
                this.serviceContainer.stopService(serviceName);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Exception while stopping service", e);
            }
        }
    }

    public List<ObjectName> getInstalledServices() {
        return this.installedServices;
    }

    public static class MBeanDeploymentOperationBuilder {
        protected MBeanServiceContainer container;
        protected String name;
        protected boolean isUndeploymentOperation = false;
        protected List<MBeanDeploymentOperationStep> steps = new ArrayList<MBeanDeploymentOperationStep>();
        protected Map<String, Object> initialAttachments = new HashMap<String, Object>();

        public MBeanDeploymentOperationBuilder(MBeanServiceContainer container, String name) {
            this.container = container;
            this.name = name;
        }

        public MBeanDeploymentOperationBuilder addStep(MBeanDeploymentOperationStep step) {
            this.steps.add(step);
            return this;
        }

        public MBeanDeploymentOperationBuilder addAttachment(String name, Object value) {
            this.initialAttachments.put(name, value);
            return this;
        }

        public MBeanDeploymentOperationBuilder setUndeploymentOperation() {
            this.isUndeploymentOperation = true;
            return this;
        }

        public void execute() {
            MBeanDeploymentOperation operation = new MBeanDeploymentOperation(this.name, this.container, this.steps);
            operation.isRollbackOnFailure = !this.isUndeploymentOperation;
            operation.attachments.putAll(this.initialAttachments);
            this.container.executeDeploymentOperation(operation);
        }
    }
}

