/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessEngineController;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEnginePluginXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.FoxFailedJobParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.FoxFailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class StartProcessEngineStep
extends MBeanDeploymentOperationStep {
    protected final ProcessEngineXml processEngineXml;

    public StartProcessEngineStep(ProcessEngineXml processEngineXml) {
        this.processEngineXml = processEngineXml;
    }

    @Override
    public String getName() {
        return "Start process engine " + this.processEngineXml.getName();
    }

    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        ProcessEngineConfigurationImpl configuration;
        String configurationClassName;
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader classLoader = null;
        if (processApplication != null) {
            classLoader = processApplication.getProcessApplicationClassloader();
        }
        if ((configurationClassName = this.processEngineXml.getConfigurationClass()) == null || configurationClassName.isEmpty()) {
            configurationClassName = StandaloneProcessEngineConfiguration.class.getName();
        }
        Class<ProcessEngineConfigurationImpl> configurationClass = this.loadClass(configurationClassName, classLoader, ProcessEngineConfigurationImpl.class);
        ProcessEngineConfigurationImpl configurationImpl = configuration = this.createInstance(configurationClass);
        configurationImpl.setIdGenerator(new StrongUuidGenerator());
        this.configureCustomRetryStrategy(configurationImpl);
        String name = this.processEngineXml.getName();
        configuration.setProcessEngineName(name);
        String datasourceJndiName = this.processEngineXml.getDatasource();
        configuration.setDataSourceJndiName(datasourceJndiName);
        Map<String, String> properties = this.processEngineXml.getProperties();
        PropertyHelper.applyProperties(configuration, properties);
        this.configurePlugins(configuration, this.processEngineXml, classLoader);
        if (this.processEngineXml.getJobAcquisitionName() != null && !this.processEngineXml.getJobAcquisitionName().isEmpty()) {
            JobExecutor jobExecutor = this.getJobExecutorService(serviceContainer);
            if (jobExecutor == null) {
                throw new ProcessEngineException("Cannot find referenced job executor with name '" + this.processEngineXml.getJobAcquisitionName() + "'");
            }
            configurationImpl.setJobExecutor(jobExecutor);
        }
        JmxManagedProcessEngineController managedProcessEngineService = new JmxManagedProcessEngineController(configuration);
        serviceContainer.startService(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, configuration.getProcessEngineName(), managedProcessEngineService);
    }

    protected void configureCustomRetryStrategy(ProcessEngineConfigurationImpl configurationImpl) {
        List<BpmnParseListener> customPostBPMNParseListeners = configurationImpl.getCustomPostBPMNParseListeners();
        if (customPostBPMNParseListeners == null) {
            customPostBPMNParseListeners = new ArrayList<BpmnParseListener>();
            configurationImpl.setCustomPostBPMNParseListeners(customPostBPMNParseListeners);
        }
        customPostBPMNParseListeners.add(new FoxFailedJobParseListener());
        configurationImpl.setFailedJobCommandFactory(new FoxFailedJobCommandFactory());
    }

    protected void configurePlugins(ProcessEngineConfigurationImpl configuration, ProcessEngineXml processEngineXml, ClassLoader classLoader) {
        for (ProcessEnginePluginXml pluginXml : processEngineXml.getPlugins()) {
            Class<ProcessEnginePlugin> pluginClass = this.loadClass(pluginXml.getPluginClass(), classLoader, ProcessEnginePlugin.class);
            ProcessEnginePlugin plugin = this.createInstance(pluginClass);
            Map<String, String> properties = pluginXml.getProperties();
            PropertyHelper.applyProperties(plugin, properties);
            configuration.getProcessEnginePlugins().add(plugin);
        }
    }

    protected JobExecutor getJobExecutorService(MBeanServiceContainer serviceContainer) {
        String jobAcquisitionName = this.processEngineXml.getJobAcquisitionName();
        JobExecutor jobExecutor = (JobExecutor)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.JOB_EXECUTOR, jobAcquisitionName);
        return jobExecutor;
    }

    protected <T> T createInstance(Class<? extends T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ProcessEngineException("Could not instantiate class", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("IllegalAccessException while instantiating class", e);
        }
    }

    protected <T> Class<? extends T> loadClass(String className, ClassLoader customClassloader, Class<T> clazz) {
        try {
            if (customClassloader != null) {
                return customClassloader.loadClass(className);
            }
            return ReflectUtil.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessEngineException("Could not load configuration class", e);
        }
        catch (ClassCastException e) {
            throw new ProcessEngineException("Custom class of wrong type. Must extend " + clazz.getName(), e);
        }
    }
}

