/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.container.impl.jmx.JmxRuntimeContainerDelegate;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.ProcessApplicationScanningUtil;
import org.camunda.bpm.container.impl.jmx.deployment.util.DeployedProcessArchive;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperation;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanDeploymentOperationStep;
import org.camunda.bpm.container.impl.jmx.kernel.MBeanServiceContainer;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;

public class DeployProcessArchiveStep
extends MBeanDeploymentOperationStep {
    protected final ProcessArchiveXml processArchive;
    protected URL metaFileUrl;
    protected ProcessApplicationDeployment deployment;

    public DeployProcessArchiveStep(ProcessArchiveXml parsedProcessArchive, URL url) {
        this.processArchive = parsedProcessArchive;
        this.metaFileUrl = url;
    }

    @Override
    public String getName() {
        return "Deployment of process archive '" + this.processArchive.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader processApplicationClassloader = processApplication.getProcessApplicationClassloader();
        ProcessEngine processEngine = this.getProcessEngine(serviceContainer);
        HashMap<String, byte[]> deploymentMap = new HashMap<String, byte[]>();
        List<String> listedProcessResources = this.processArchive.getProcessResourceNames();
        for (String processResource : listedProcessResources) {
            InputStream resourceAsStream = null;
            try {
                resourceAsStream = processApplicationClassloader.getResourceAsStream(processResource);
                byte[] bytes = IoUtil.readInputStream(resourceAsStream, processResource);
                deploymentMap.put(processResource, bytes);
            }
            finally {
                IoUtil.closeSilently(resourceAsStream);
            }
        }
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isScanForProcessDefinitions", true)) {
            String paResourceRoot = this.processArchive.getProperties().get("resourceRootPath");
            deploymentMap.putAll(ProcessApplicationScanningUtil.findResources(processApplicationClassloader, paResourceRoot, this.metaFileUrl));
        }
        RepositoryService repositoryService = processEngine.getRepositoryService();
        ProcessApplicationDeploymentBuilder deploymentBuilder = repositoryService.createDeployment(processApplication.getReference());
        String deploymentName = this.processArchive.getName();
        if (deploymentName == null || deploymentName.isEmpty()) {
            deploymentName = processApplication.getName();
        }
        deploymentBuilder.name(deploymentName);
        deploymentBuilder.enableDuplicateFiltering();
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isResumePreviousVersions", true)) {
            deploymentBuilder.resumePreviousVersions();
        }
        for (Map.Entry deploymentResource : deploymentMap.entrySet()) {
            deploymentBuilder.addInputStream((String)deploymentResource.getKey(), new ByteArrayInputStream((byte[])deploymentResource.getValue()));
        }
        processApplication.createDeployment(this.processArchive.getName(), deploymentBuilder);
        Collection<String> deploymentResourceNames = deploymentBuilder.getResourceNames();
        if (!deploymentResourceNames.isEmpty()) {
            this.logDeploymentSummary(deploymentResourceNames, deploymentName);
            this.deployment = deploymentBuilder.deploy();
            HashMap<String, DeployedProcessArchive> processArchiveDeploymentMap = (HashMap<String, DeployedProcessArchive>)operationContext.getAttachment("processArchiveDeploymentMap");
            if (processArchiveDeploymentMap == null) {
                processArchiveDeploymentMap = new HashMap<String, DeployedProcessArchive>();
                operationContext.addAttachment("processArchiveDeploymentMap", processArchiveDeploymentMap);
            }
            processArchiveDeploymentMap.put(this.processArchive.getName(), new DeployedProcessArchive(this.deployment));
        } else {
            this.LOGGER.info("Not creating a deployment for process archive '" + this.processArchive.getName() + "': no resources provided.");
        }
    }

    protected void logDeploymentSummary(Collection<String> deploymentResourceNames, String deploymentName) {
        StringBuilder builder = new StringBuilder();
        builder.append("Deployment summary for process archive '" + deploymentName + "': \n");
        builder.append("\n");
        for (String resourceName : deploymentResourceNames) {
            builder.append("        " + resourceName);
            builder.append("\n");
        }
        this.LOGGER.log(Level.INFO, builder.toString());
    }

    @Override
    public void cancelOperationStep(MBeanDeploymentOperation operationContext) {
        MBeanServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessEngine processEngine = this.getProcessEngine(serviceContainer);
        if (this.deployment != null && this.deployment.getProcessApplicationRegistration() != null) {
            processEngine.getManagementService().unregisterProcessApplication(this.deployment.getProcessApplicationRegistration().getDeploymentIds(), true);
        }
        if (this.deployment != null && PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeleteUponUndeploy", false) && processEngine != null) {
            processEngine.getRepositoryService().deleteDeployment(this.deployment.getId(), true);
        }
    }

    protected ProcessEngine getProcessEngine(MBeanServiceContainer serviceContainer) {
        String processEngineName = this.processArchive.getProcessEngineName();
        if (processEngineName != null) {
            ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, processEngineName);
            if (processEngine == null) {
                throw new ProcessEngineException("Cannot deploy process archive '" + this.processArchive.getName() + "' to process engine '" + processEngineName + "' no such process engine exists.");
            }
            return processEngine;
        }
        ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(JmxRuntimeContainerDelegate.ServiceTypes.PROCESS_ENGINE, "default");
        if (processEngine == null) {
            throw new ProcessEngineException("Cannot deploy process archive '" + this.processArchive.getName() + "' to default process: no such process engine exists.");
        }
        return processEngine;
    }
}

