/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl;

import java.util.concurrent.Callable;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationExecutionException;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EjbProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public class EjbProcessApplication
extends AbstractProcessApplication {
    protected static String MODULE_NAME_PATH = "java:module/ModuleName";
    protected static String JAVA_APP_APP_NAME_PATH = "java:app/AppName";
    protected static String EJB_CONTEXT_PATH = "java:comp/EJBContext";
    private EjbProcessApplicationReference ejbProcessApplicationReference;
    private ProcessApplicationInterface selfReference;

    @Override
    public ProcessApplicationReference getReference() {
        this.ensureInitialized();
        return this.ejbProcessApplicationReference;
    }

    @Override
    protected String autodetectProcessApplicationName() {
        return this.lookupEeApplicationName();
    }

    protected Class<? extends ProcessApplicationInterface> getBusinessInterface() {
        return ProcessApplicationInterface.class;
    }

    @Override
    public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
        ClassLoader originalClassloader = ClassLoaderUtil.getContextClassloader();
        ClassLoader processApplicationClassloader = this.getProcessApplicationClassloader();
        try {
            if (originalClassloader != processApplicationClassloader) {
                ClassLoaderUtil.setContextClassloader(processApplicationClassloader);
            }
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new ProcessApplicationExecutionException(e);
        }
        finally {
            ClassLoaderUtil.setContextClassloader(originalClassloader);
        }
    }

    protected void ensureInitialized() {
        if (this.selfReference == null) {
            this.selfReference = this.lookupSelfReference();
        }
        if (this.ejbProcessApplicationReference == null) {
            this.ejbProcessApplicationReference = new EjbProcessApplicationReference(this.selfReference, this.getName());
        }
    }

    protected ProcessApplicationInterface lookupSelfReference() {
        try {
            InitialContext ic = new InitialContext();
            SessionContext sctxLookup = (SessionContext)ic.lookup(EJB_CONTEXT_PATH);
            return (ProcessApplicationInterface)sctxLookup.getBusinessObject(this.getBusinessInterface());
        }
        catch (NamingException e) {
            throw new ProcessEngineException("Cannot lookup self reference to EjbProcessApplication", e);
        }
    }

    protected String lookupEeApplicationName() {
        try {
            InitialContext initialContext = new InitialContext();
            String appName = (String)initialContext.lookup(JAVA_APP_APP_NAME_PATH);
            String moduleName = (String)initialContext.lookup(MODULE_NAME_PATH);
            if (moduleName != null && !moduleName.equals(appName)) {
                return appName + "/" + moduleName;
            }
            return appName;
        }
        catch (NamingException e) {
            throw new ProcessEngineException("Could not autodetect EjbProcessApplicationName: " + e.getMessage(), e);
        }
    }
}

