/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.impl.test;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public class SpringProcessEngineTestCase
extends AbstractProcessEngineTestCase
implements ApplicationContextAware {
    protected static Map<String, ProcessEngine> cachedProcessEngines = new HashMap<String, ProcessEngine>();
    protected TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());
    @Autowired
    protected ApplicationContext applicationContext;

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        super.runBare();
    }

    protected void initializeProcessEngine() {
        ContextConfiguration contextConfiguration = ((Object)((Object)this)).getClass().getAnnotation(ContextConfiguration.class);
        String processEngineKey = this.createProcessEngineKey(contextConfiguration);
        this.processEngine = cachedProcessEngines.get(processEngineKey);
        if (this.processEngine == null) {
            this.processEngine = (ProcessEngine)this.applicationContext.getBean(ProcessEngine.class);
            cachedProcessEngines.put(processEngineKey, this.processEngine);
        }
    }

    protected String createProcessEngineKey(ContextConfiguration contextConfiguration) {
        String processEngineKey = null;
        String[] value = contextConfiguration.value();
        Class[] classes = contextConfiguration.classes();
        if (value.length > 1 || classes.length > 1) {
            throw new ProcessEngineException("SpringProcessEngineTestCase requires exactly one value in annotation ContextConfiguration");
        }
        if (value != null && value.length == 1) {
            processEngineKey = value[0];
        } else if (classes != null && classes.length == 1) {
            processEngineKey = classes[0].getName();
        }
        if (processEngineKey == null) {
            throw new ProcessEngineException("value or classes is mandatory in ContextConfiguration");
        }
        return processEngineKey;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

