/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.client.model.ActivityInstanceIncidentDto;

/**
 * A JSON object corresponding to the Activity Instance tree of the given process instance.
 */
@ApiModel(description = "A JSON object corresponding to the Activity Instance tree of the given process instance.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class TransitionInstanceDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
  @SerializedName(SERIALIZED_NAME_PARENT_ACTIVITY_INSTANCE_ID)
  private String parentActivityInstanceId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_NAME)
  private String activityName;

  public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_TYPE)
  private String activityType;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_INCIDENT_IDS = "incidentIds";
  @SerializedName(SERIALIZED_NAME_INCIDENT_IDS)
  private List<String> incidentIds = null;

  public static final String SERIALIZED_NAME_INCIDENTS = "incidents";
  @SerializedName(SERIALIZED_NAME_INCIDENTS)
  private List<ActivityInstanceIncidentDto> incidents = null;


  public TransitionInstanceDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the transition instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the transition instance.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public TransitionInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
    
    this.parentActivityInstanceId = parentActivityInstanceId;
    return this;
  }

   /**
   * The id of the parent activity instance, for example a sub process instance.
   * @return parentActivityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the parent activity instance, for example a sub process instance.")

  public String getParentActivityInstanceId() {
    return parentActivityInstanceId;
  }


  public void setParentActivityInstanceId(String parentActivityInstanceId) {
    this.parentActivityInstanceId = parentActivityInstanceId;
  }


  public TransitionInstanceDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The id of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public TransitionInstanceDto activityName(String activityName) {
    
    this.activityName = activityName;
    return this;
  }

   /**
   * The name of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")

  public String getActivityName() {
    return activityName;
  }


  public void setActivityName(String activityName) {
    this.activityName = activityName;
  }


  public TransitionInstanceDto activityType(String activityType) {
    
    this.activityType = activityType;
    return this;
  }

   /**
   * The type of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)
   * @return activityType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the activity that this instance enters (asyncBefore job) or leaves (asyncAfter job)")

  public String getActivityType() {
    return activityType;
  }


  public void setActivityType(String activityType) {
    this.activityType = activityType;
  }


  public TransitionInstanceDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The id of the process instance this instance is part of.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process instance this instance is part of.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public TransitionInstanceDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * The id of the process definition.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process definition.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public TransitionInstanceDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The execution id.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution id.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public TransitionInstanceDto incidentIds(List<String> incidentIds) {
    
    this.incidentIds = incidentIds;
    return this;
  }

  public TransitionInstanceDto addIncidentIdsItem(String incidentIdsItem) {
    if (this.incidentIds == null) {
      this.incidentIds = new ArrayList<String>();
    }
    this.incidentIds.add(incidentIdsItem);
    return this;
  }

   /**
   * A list of incident ids.
   * @return incidentIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of incident ids.")

  public List<String> getIncidentIds() {
    return incidentIds;
  }


  public void setIncidentIds(List<String> incidentIds) {
    this.incidentIds = incidentIds;
  }


  public TransitionInstanceDto incidents(List<ActivityInstanceIncidentDto> incidents) {
    
    this.incidents = incidents;
    return this;
  }

  public TransitionInstanceDto addIncidentsItem(ActivityInstanceIncidentDto incidentsItem) {
    if (this.incidents == null) {
      this.incidents = new ArrayList<ActivityInstanceIncidentDto>();
    }
    this.incidents.add(incidentsItem);
    return this;
  }

   /**
   * A list of JSON objects containing incident specific properties: * &#x60;id&#x60;: the id of the incident * &#x60;activityId&#x60;: the activity id in which the incident occurred
   * @return incidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of JSON objects containing incident specific properties: * `id`: the id of the incident * `activityId`: the activity id in which the incident occurred")

  public List<ActivityInstanceIncidentDto> getIncidents() {
    return incidents;
  }


  public void setIncidents(List<ActivityInstanceIncidentDto> incidents) {
    this.incidents = incidents;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransitionInstanceDto transitionInstanceDto = (TransitionInstanceDto) o;
    return Objects.equals(this.id, transitionInstanceDto.id) &&
        Objects.equals(this.parentActivityInstanceId, transitionInstanceDto.parentActivityInstanceId) &&
        Objects.equals(this.activityId, transitionInstanceDto.activityId) &&
        Objects.equals(this.activityName, transitionInstanceDto.activityName) &&
        Objects.equals(this.activityType, transitionInstanceDto.activityType) &&
        Objects.equals(this.processInstanceId, transitionInstanceDto.processInstanceId) &&
        Objects.equals(this.processDefinitionId, transitionInstanceDto.processDefinitionId) &&
        Objects.equals(this.executionId, transitionInstanceDto.executionId) &&
        Objects.equals(this.incidentIds, transitionInstanceDto.incidentIds) &&
        Objects.equals(this.incidents, transitionInstanceDto.incidents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, parentActivityInstanceId, activityId, activityName, activityType, processInstanceId, processDefinitionId, executionId, incidentIds, incidents);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransitionInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    parentActivityInstanceId: ").append(toIndentedString(parentActivityInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    incidentIds: ").append(toIndentedString(incidentIds)).append("\n");
    sb.append("    incidents: ").append(toIndentedString(incidents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

