/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.client.model.HistoricProcessInstanceQueryDto;
import org.openapitools.client.model.RestartProcessInstanceModificationInstructionDto;

/**
 * RestartProcessInstanceDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class RestartProcessInstanceDto {
  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_IDS)
  private List<String> processInstanceIds = null;

  public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  @SerializedName(SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY)
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
  @SerializedName(SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS)
  private Boolean skipCustomListeners;

  public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
  @SerializedName(SERIALIZED_NAME_SKIP_IO_MAPPINGS)
  private Boolean skipIoMappings;

  public static final String SERIALIZED_NAME_INITIAL_VARIABLES = "initialVariables";
  @SerializedName(SERIALIZED_NAME_INITIAL_VARIABLES)
  private Boolean initialVariables;

  public static final String SERIALIZED_NAME_WITHOUT_BUSINESS_KEY = "withoutBusinessKey";
  @SerializedName(SERIALIZED_NAME_WITHOUT_BUSINESS_KEY)
  private Boolean withoutBusinessKey;

  public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
  @SerializedName(SERIALIZED_NAME_INSTRUCTIONS)
  private List<RestartProcessInstanceModificationInstructionDto> instructions = null;


  public RestartProcessInstanceDto processInstanceIds(List<String> processInstanceIds) {
    
    this.processInstanceIds = processInstanceIds;
    return this;
  }

  public RestartProcessInstanceDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
    if (this.processInstanceIds == null) {
      this.processInstanceIds = new ArrayList<String>();
    }
    this.processInstanceIds.add(processInstanceIdsItem);
    return this;
  }

   /**
   * A list of process instance ids to restart.
   * @return processInstanceIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A list of process instance ids to restart.")

  public List<String> getProcessInstanceIds() {
    return processInstanceIds;
  }


  public void setProcessInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = processInstanceIds;
  }


  public RestartProcessInstanceDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }


  public RestartProcessInstanceDto skipCustomListeners(Boolean skipCustomListeners) {
    
    this.skipCustomListeners = skipCustomListeners;
    return this;
  }

   /**
   * Skip execution listener invocation for activities that are started as part of this request.
   * @return skipCustomListeners
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Skip execution listener invocation for activities that are started as part of this request.")

  public Boolean getSkipCustomListeners() {
    return skipCustomListeners;
  }


  public void setSkipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = skipCustomListeners;
  }


  public RestartProcessInstanceDto skipIoMappings(Boolean skipIoMappings) {
    
    this.skipIoMappings = skipIoMappings;
    return this;
  }

   /**
   * Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.22/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started as part of this request.
   * @return skipIoMappings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.22/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started as part of this request.")

  public Boolean getSkipIoMappings() {
    return skipIoMappings;
  }


  public void setSkipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = skipIoMappings;
  }


  public RestartProcessInstanceDto initialVariables(Boolean initialVariables) {
    
    this.initialVariables = initialVariables;
    return this;
  }

   /**
   * Set the initial set of variables during restart. By default, the last set of variables is used.
   * @return initialVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Set the initial set of variables during restart. By default, the last set of variables is used.")

  public Boolean getInitialVariables() {
    return initialVariables;
  }


  public void setInitialVariables(Boolean initialVariables) {
    this.initialVariables = initialVariables;
  }


  public RestartProcessInstanceDto withoutBusinessKey(Boolean withoutBusinessKey) {
    
    this.withoutBusinessKey = withoutBusinessKey;
    return this;
  }

   /**
   * Do not take over the business key of the historic process instance.
   * @return withoutBusinessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Do not take over the business key of the historic process instance.")

  public Boolean getWithoutBusinessKey() {
    return withoutBusinessKey;
  }


  public void setWithoutBusinessKey(Boolean withoutBusinessKey) {
    this.withoutBusinessKey = withoutBusinessKey;
  }


  public RestartProcessInstanceDto instructions(List<RestartProcessInstanceModificationInstructionDto> instructions) {
    
    this.instructions = instructions;
    return this;
  }

  public RestartProcessInstanceDto addInstructionsItem(RestartProcessInstanceModificationInstructionDto instructionsItem) {
    if (this.instructions == null) {
      this.instructions = new ArrayList<RestartProcessInstanceModificationInstructionDto>();
    }
    this.instructions.add(instructionsItem);
    return this;
  }

   /**
   * **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.
   * @return instructions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.")

  public List<RestartProcessInstanceModificationInstructionDto> getInstructions() {
    return instructions;
  }


  public void setInstructions(List<RestartProcessInstanceModificationInstructionDto> instructions) {
    this.instructions = instructions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestartProcessInstanceDto restartProcessInstanceDto = (RestartProcessInstanceDto) o;
    return Objects.equals(this.processInstanceIds, restartProcessInstanceDto.processInstanceIds) &&
        Objects.equals(this.historicProcessInstanceQuery, restartProcessInstanceDto.historicProcessInstanceQuery) &&
        Objects.equals(this.skipCustomListeners, restartProcessInstanceDto.skipCustomListeners) &&
        Objects.equals(this.skipIoMappings, restartProcessInstanceDto.skipIoMappings) &&
        Objects.equals(this.initialVariables, restartProcessInstanceDto.initialVariables) &&
        Objects.equals(this.withoutBusinessKey, restartProcessInstanceDto.withoutBusinessKey) &&
        Objects.equals(this.instructions, restartProcessInstanceDto.instructions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processInstanceIds, historicProcessInstanceQuery, skipCustomListeners, skipIoMappings, initialVariables, withoutBusinessKey, instructions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestartProcessInstanceDto {\n");
    sb.append("    processInstanceIds: ").append(toIndentedString(processInstanceIds)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("    skipCustomListeners: ").append(toIndentedString(skipCustomListeners)).append("\n");
    sb.append("    skipIoMappings: ").append(toIndentedString(skipIoMappings)).append("\n");
    sb.append("    initialVariables: ").append(toIndentedString(initialVariables)).append("\n");
    sb.append("    withoutBusinessKey: ").append(toIndentedString(withoutBusinessKey)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

