/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.IOException;
import java.util.Date;

/**
 * MultiFormDeploymentDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class MultiFormDeploymentDto {
  public static final String SERIALIZED_NAME_TENANT_ID = "tenant-id";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_DEPLOYMENT_SOURCE = "deployment-source";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_SOURCE)
  private String deploymentSource;

  public static final String SERIALIZED_NAME_DEPLOY_CHANGED_ONLY = "deploy-changed-only";
  @SerializedName(SERIALIZED_NAME_DEPLOY_CHANGED_ONLY)
  private Boolean deployChangedOnly = false;

  public static final String SERIALIZED_NAME_ENABLE_DUPLICATE_FILTERING = "enable-duplicate-filtering";
  @SerializedName(SERIALIZED_NAME_ENABLE_DUPLICATE_FILTERING)
  private Boolean enableDuplicateFiltering = false;

  public static final String SERIALIZED_NAME_DEPLOYMENT_NAME = "deployment-name";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_NAME)
  private String deploymentName;

  public static final String SERIALIZED_NAME_DEPLOYMENT_ACTIVATION_TIME = "deployment-activation-time";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_ACTIVATION_TIME)
  private Date deploymentActivationTime;

  public static final String SERIALIZED_NAME_DATA = "data";
  @SerializedName(SERIALIZED_NAME_DATA)
  private File data;


  public MultiFormDeploymentDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The tenant id for the deployment to be created.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The tenant id for the deployment to be created.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public MultiFormDeploymentDto deploymentSource(String deploymentSource) {
    
    this.deploymentSource = deploymentSource;
    return this;
  }

   /**
   * The source for the deployment to be created.
   * @return deploymentSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The source for the deployment to be created.")

  public String getDeploymentSource() {
    return deploymentSource;
  }


  public void setDeploymentSource(String deploymentSource) {
    this.deploymentSource = deploymentSource;
  }


  public MultiFormDeploymentDto deployChangedOnly(Boolean deployChangedOnly) {
    
    this.deployChangedOnly = deployChangedOnly;
    return this;
  }

   /**
   * A flag indicating whether the process engine should perform duplicate checking on a per-resource basis. If set to true, only those resources that have actually changed are deployed. Checks are made against resources included previous deployments of the same name and source and only against the latest versions of those resources. If set to true, the option enable-duplicate-filtering is overridden and set to true.
   * @return deployChangedOnly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether the process engine should perform duplicate checking on a per-resource basis. If set to true, only those resources that have actually changed are deployed. Checks are made against resources included previous deployments of the same name and source and only against the latest versions of those resources. If set to true, the option enable-duplicate-filtering is overridden and set to true.")

  public Boolean getDeployChangedOnly() {
    return deployChangedOnly;
  }


  public void setDeployChangedOnly(Boolean deployChangedOnly) {
    this.deployChangedOnly = deployChangedOnly;
  }


  public MultiFormDeploymentDto enableDuplicateFiltering(Boolean enableDuplicateFiltering) {
    
    this.enableDuplicateFiltering = enableDuplicateFiltering;
    return this;
  }

   /**
   * A flag indicating whether the process engine should perform duplicate checking for the deployment or not. This allows you to check if a deployment with the same name and the same resouces already exists and if true, not create a new deployment but instead return the existing deployment. The default value is false.
   * @return enableDuplicateFiltering
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether the process engine should perform duplicate checking for the deployment or not. This allows you to check if a deployment with the same name and the same resouces already exists and if true, not create a new deployment but instead return the existing deployment. The default value is false.")

  public Boolean getEnableDuplicateFiltering() {
    return enableDuplicateFiltering;
  }


  public void setEnableDuplicateFiltering(Boolean enableDuplicateFiltering) {
    this.enableDuplicateFiltering = enableDuplicateFiltering;
  }


  public MultiFormDeploymentDto deploymentName(String deploymentName) {
    
    this.deploymentName = deploymentName;
    return this;
  }

   /**
   * The name for the deployment to be created.
   * @return deploymentName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name for the deployment to be created.")

  public String getDeploymentName() {
    return deploymentName;
  }


  public void setDeploymentName(String deploymentName) {
    this.deploymentName = deploymentName;
  }


  public MultiFormDeploymentDto deploymentActivationTime(Date deploymentActivationTime) {
    
    this.deploymentActivationTime = deploymentActivationTime;
    return this;
  }

   /**
   * Sets the date on which the process definitions contained in this deployment will be activated. This means that all process definitions will be deployed as usual, but they will be suspended from the start until the given activation date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return deploymentActivationTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sets the date on which the process definitions contained in this deployment will be activated. This means that all process definitions will be deployed as usual, but they will be suspended from the start until the given activation date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getDeploymentActivationTime() {
    return deploymentActivationTime;
  }


  public void setDeploymentActivationTime(Date deploymentActivationTime) {
    this.deploymentActivationTime = deploymentActivationTime;
  }


  public MultiFormDeploymentDto data(File data) {
    
    this.data = data;
    return this;
  }

   /**
   * The binary data to create the deployment resource. It is possible to have more than one form part with different form part names for the binary data to create a deployment.
   * @return data
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The binary data to create the deployment resource. It is possible to have more than one form part with different form part names for the binary data to create a deployment.")

  public File getData() {
    return data;
  }


  public void setData(File data) {
    this.data = data;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultiFormDeploymentDto multiFormDeploymentDto = (MultiFormDeploymentDto) o;
    return Objects.equals(this.tenantId, multiFormDeploymentDto.tenantId) &&
        Objects.equals(this.deploymentSource, multiFormDeploymentDto.deploymentSource) &&
        Objects.equals(this.deployChangedOnly, multiFormDeploymentDto.deployChangedOnly) &&
        Objects.equals(this.enableDuplicateFiltering, multiFormDeploymentDto.enableDuplicateFiltering) &&
        Objects.equals(this.deploymentName, multiFormDeploymentDto.deploymentName) &&
        Objects.equals(this.deploymentActivationTime, multiFormDeploymentDto.deploymentActivationTime) &&
        Objects.equals(this.data, multiFormDeploymentDto.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultiFormDeploymentDto {\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    deploymentSource: ").append(toIndentedString(deploymentSource)).append("\n");
    sb.append("    deployChangedOnly: ").append(toIndentedString(deployChangedOnly)).append("\n");
    sb.append("    enableDuplicateFiltering: ").append(toIndentedString(enableDuplicateFiltering)).append("\n");
    sb.append("    deploymentName: ").append(toIndentedString(deploymentName)).append("\n");
    sb.append("    deploymentActivationTime: ").append(toIndentedString(deploymentActivationTime)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

