/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * AuthorizationDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class AuthorizationDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private Integer type;

  public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
  @SerializedName(SERIALIZED_NAME_PERMISSIONS)
  private List<String> permissions = null;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private String userId;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private String groupId;

  public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
  @SerializedName(SERIALIZED_NAME_RESOURCE_TYPE)
  private Integer resourceType;

  public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_ID)
  private String resourceId;

  public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
  @SerializedName(SERIALIZED_NAME_REMOVAL_TIME)
  private Date removalTime;

  public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  @SerializedName(SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID)
  private String rootProcessInstanceId;


  public AuthorizationDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the authorization.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the authorization.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public AuthorizationDto type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the authorization (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the authorization (0=global, 1=grant, 2=revoke). See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.")

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public AuthorizationDto permissions(List<String> permissions) {
    
    this.permissions = permissions;
    return this;
  }

  public AuthorizationDto addPermissionsItem(String permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<String>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * An array of Strings holding the permissions provided by this authorization.
   * @return permissions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of Strings holding the permissions provided by this authorization.")

  public List<String> getPermissions() {
    return permissions;
  }


  public void setPermissions(List<String> permissions) {
    this.permissions = permissions;
  }


  public AuthorizationDto userId(String userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * The id of the user this authorization has been created for. The value &#x60;*&#x60; represents a global authorization ranging over all users.
   * @return userId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.")

  public String getUserId() {
    return userId;
  }


  public void setUserId(String userId) {
    this.userId = userId;
  }


  public AuthorizationDto groupId(String groupId) {
    
    this.groupId = groupId;
    return this;
  }

   /**
   * The id of the group this authorization has been created for.
   * @return groupId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the group this authorization has been created for.")

  public String getGroupId() {
    return groupId;
  }


  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  public AuthorizationDto resourceType(Integer resourceType) {
    
    this.resourceType = resourceType;
    return this;
  }

   /**
   * An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.")

  public Integer getResourceType() {
    return resourceType;
  }


  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }


  public AuthorizationDto resourceId(String resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

   /**
   * The resource Id. The value &#x60;*&#x60; represents an authorization ranging over all instances of a resource.
   * @return resourceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The resource Id. The value `*` represents an authorization ranging over all instances of a resource.")

  public String getResourceId() {
    return resourceId;
  }


  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }


  public AuthorizationDto removalTime(Date removalTime) {
    
    this.removalTime = removalTime;
    return this;
  }

   /**
   * The removal time indicates the date a historic instance authorization is cleaned up. A removal time can only be assigned to a historic instance authorization. Can be &#x60;null&#x60; when not related to a historic instance resource or when the removal time strategy is end and the root process instance is not finished. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The removal time indicates the date a historic instance authorization is cleaned up. A removal time can only be assigned to a historic instance authorization. Can be `null` when not related to a historic instance resource or when the removal time strategy is end and the root process instance is not finished. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")

  public Date getRemovalTime() {
    return removalTime;
  }


  public void setRemovalTime(Date removalTime) {
    this.removalTime = removalTime;
  }


  public AuthorizationDto rootProcessInstanceId(String rootProcessInstanceId) {
    
    this.rootProcessInstanceId = rootProcessInstanceId;
    return this;
  }

   /**
   * The process instance id of the root process instance the historic instance authorization is related to. Can be &#x60;null&#x60; if not related to a historic instance resource.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The process instance id of the root process instance the historic instance authorization is related to. Can be `null` if not related to a historic instance resource.")

  public String getRootProcessInstanceId() {
    return rootProcessInstanceId;
  }


  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationDto authorizationDto = (AuthorizationDto) o;
    return Objects.equals(this.id, authorizationDto.id) &&
        Objects.equals(this.type, authorizationDto.type) &&
        Objects.equals(this.permissions, authorizationDto.permissions) &&
        Objects.equals(this.userId, authorizationDto.userId) &&
        Objects.equals(this.groupId, authorizationDto.groupId) &&
        Objects.equals(this.resourceType, authorizationDto.resourceType) &&
        Objects.equals(this.resourceId, authorizationDto.resourceId) &&
        Objects.equals(this.removalTime, authorizationDto.removalTime) &&
        Objects.equals(this.rootProcessInstanceId, authorizationDto.rootProcessInstanceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, permissions, userId, groupId, resourceType, resourceId, removalTime, rootProcessInstanceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

