/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CountResultDto;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.ResourceOptionsDto;
import org.openapitools.client.model.TenantDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantApi {
    private ApiClient localVarApiClient;

    public TenantApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TenantApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for availableTenantGroupMembersOperations
     * @param id The id of the tenant (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantGroupMembersOperationsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/group-members"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call availableTenantGroupMembersOperationsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantGroupMembersOperations(Async)");
        }
        

        okhttp3.Call localVarCall = availableTenantGroupMembersOperationsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Tenant Group Membership Resource Options
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto availableTenantGroupMembersOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = availableTenantGroupMembersOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Tenant Group Membership Resource Options
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> availableTenantGroupMembersOperationsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = availableTenantGroupMembersOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Tenant Group Membership Resource Options (asynchronously)
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantGroupMembersOperationsAsync(String id, final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = availableTenantGroupMembersOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for availableTenantInstanceOperations
     * @param id The id of the tenant (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantInstanceOperationsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call availableTenantInstanceOperationsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantInstanceOperations(Async)");
        }
        

        okhttp3.Call localVarCall = availableTenantInstanceOperationsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Tenant Resource Options
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, one for the resource as such and this one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant/{id}&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto availableTenantInstanceOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = availableTenantInstanceOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Tenant Resource Options
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, one for the resource as such and this one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant/{id}&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> availableTenantInstanceOperationsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = availableTenantInstanceOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Tenant Resource Options (asynchronously)
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, one for the resource as such and this one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant/{id}&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantInstanceOperationsAsync(String id, final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = availableTenantInstanceOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for availableTenantResourceOperations
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantResourceOperationsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call availableTenantResourceOperationsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = availableTenantResourceOperationsCall(_callback);
        return localVarCall;

    }

    /**
     * Tenant Resource Options
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, this one for the resource as such and one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto availableTenantResourceOperations() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = availableTenantResourceOperationsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Tenant Resource Options
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, this one for the resource as such and one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> availableTenantResourceOperationsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = availableTenantResourceOperationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Tenant Resource Options (asynchronously)
     * The &#x60;/tenant&#x60; resource supports two custom OPTIONS requests, this one for the resource as such and one for individual tenant instances. The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the &#x60;/tenant&#x60; resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantResourceOperationsAsync(final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = availableTenantResourceOperationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for availableTenantUserMembersOperations
     * @param id The id of the tenant (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantUserMembersOperationsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/user-members"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call availableTenantUserMembersOperationsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableTenantUserMembersOperations(Async)");
        }
        

        okhttp3.Call localVarCall = availableTenantUserMembersOperationsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Tenant User Membership Resource Options
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto availableTenantUserMembersOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = availableTenantUserMembersOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Tenant User Membership Resource Options
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> availableTenantUserMembersOperationsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = availableTenantUserMembersOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Tenant User Membership Resource Options (asynchronously)
     * The OPTIONS request allows checking for the set of available operations that the currently authenticated user can perform on the resource. If the user can perform an operation or not may depend on various things, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the tenant (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call availableTenantUserMembersOperationsAsync(String id, final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = availableTenantUserMembersOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createGroupMembership
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createGroupMembershipCall(String id, String groupId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/group-members/{groupId}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "groupId" + "\\}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createGroupMembershipValidateBeforeCall(String id, String groupId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createGroupMembership(Async)");
        }
        
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling createGroupMembership(Async)");
        }
        

        okhttp3.Call localVarCall = createGroupMembershipCall(id, groupId, _callback);
        return localVarCall;

    }

    /**
     * Create Tenant Group Membership
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void createGroupMembership(String id, String groupId) throws ApiException {
        createGroupMembershipWithHttpInfo(id, groupId);
    }

    /**
     * Create Tenant Group Membership
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createGroupMembershipWithHttpInfo(String id, String groupId) throws ApiException {
        okhttp3.Call localVarCall = createGroupMembershipValidateBeforeCall(id, groupId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create Tenant Group Membership (asynchronously)
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createGroupMembershipAsync(String id, String groupId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createGroupMembershipValidateBeforeCall(id, groupId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTenant
     * @param tenantDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be created due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTenantCall(TenantDto tenantDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = tenantDto;

        // create path and map variables
        String localVarPath = "/tenant/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTenantValidateBeforeCall(TenantDto tenantDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createTenantCall(tenantDto, _callback);
        return localVarCall;

    }

    /**
     * Create Tenant
     * Create a new tenant.
     * @param tenantDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be created due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void createTenant(TenantDto tenantDto) throws ApiException {
        createTenantWithHttpInfo(tenantDto);
    }

    /**
     * Create Tenant
     * Create a new tenant.
     * @param tenantDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be created due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createTenantWithHttpInfo(TenantDto tenantDto) throws ApiException {
        okhttp3.Call localVarCall = createTenantValidateBeforeCall(tenantDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create Tenant (asynchronously)
     * Create a new tenant.
     * @param tenantDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be created due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTenantAsync(TenantDto tenantDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTenantValidateBeforeCall(tenantDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for createUserMembership
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserMembershipCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/user-members/{userId}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "userId" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUserMembershipValidateBeforeCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createUserMembership(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserMembership(Async)");
        }
        

        okhttp3.Call localVarCall = createUserMembershipCall(id, userId, _callback);
        return localVarCall;

    }

    /**
     * Create Tenant User Membership
     * Creates a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void createUserMembership(String id, String userId) throws ApiException {
        createUserMembershipWithHttpInfo(id, userId);
    }

    /**
     * Create Tenant User Membership
     * Creates a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createUserMembershipWithHttpInfo(String id, String userId) throws ApiException {
        okhttp3.Call localVarCall = createUserMembershipValidateBeforeCall(id, userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create Tenant User Membership (asynchronously)
     * Creates a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserMembershipAsync(String id, String userId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createUserMembershipValidateBeforeCall(id, userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteGroupMembership
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupMembershipCall(String id, String groupId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/group-members/{groupId}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "groupId" + "\\}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteGroupMembershipValidateBeforeCall(String id, String groupId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteGroupMembership(Async)");
        }
        
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroupMembership(Async)");
        }
        

        okhttp3.Call localVarCall = deleteGroupMembershipCall(id, groupId, _callback);
        return localVarCall;

    }

    /**
     * Create Tenant Group Membership
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteGroupMembership(String id, String groupId) throws ApiException {
        deleteGroupMembershipWithHttpInfo(id, groupId);
    }

    /**
     * Create Tenant Group Membership
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteGroupMembershipWithHttpInfo(String id, String groupId) throws ApiException {
        okhttp3.Call localVarCall = deleteGroupMembershipValidateBeforeCall(id, groupId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create Tenant Group Membership (asynchronously)
     * Creates a membership between a tenant and a group.
     * @param id The id of the tenant. (required)
     * @param groupId The id of the group. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an internal error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupMembershipAsync(String id, String groupId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteGroupMembershipValidateBeforeCall(id, groupId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTenant
     * @param id The id of the tenant to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTenantCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTenantValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTenant(Async)");
        }
        

        okhttp3.Call localVarCall = deleteTenantCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Tenant
     * Deletes a tenant by id.
     * @param id The id of the tenant to be deleted. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTenant(String id) throws ApiException {
        deleteTenantWithHttpInfo(id);
    }

    /**
     * Delete Tenant
     * Deletes a tenant by id.
     * @param id The id of the tenant to be deleted. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTenantWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteTenantValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Tenant (asynchronously)
     * Deletes a tenant by id.
     * @param id The id of the tenant to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTenantAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTenantValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteUserMembership
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserMembershipCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}/user-members/{userId}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "userId" + "\\}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUserMembershipValidateBeforeCall(String id, String userId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteUserMembership(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserMembership(Async)");
        }
        

        okhttp3.Call localVarCall = deleteUserMembershipCall(id, userId, _callback);
        return localVarCall;

    }

    /**
     * Delete a Tenant User Membership
     * Deletes a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteUserMembership(String id, String userId) throws ApiException {
        deleteUserMembershipWithHttpInfo(id, userId);
    }

    /**
     * Delete a Tenant User Membership
     * Deletes a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteUserMembershipWithHttpInfo(String id, String userId) throws ApiException {
        okhttp3.Call localVarCall = deleteUserMembershipValidateBeforeCall(id, userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a Tenant User Membership (asynchronously)
     * Deletes a membership between a tenant and an user.
     * @param id The id of the tenant. (required)
     * @param userId The id of the user. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> In case an error occurs. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserMembershipAsync(String id, String userId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUserMembershipValidateBeforeCall(id, userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTenant
     * @param id The id of the tenant to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTenantCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTenantValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTenant(Async)");
        }
        

        okhttp3.Call localVarCall = getTenantCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Tenant
     * Retrieves a tenant.
     * @param id The id of the tenant to be retrieved. (required)
     * @return TenantDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public TenantDto getTenant(String id) throws ApiException {
        ApiResponse<TenantDto> localVarResp = getTenantWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Tenant
     * Retrieves a tenant.
     * @param id The id of the tenant to be retrieved. (required)
     * @return ApiResponse&lt;TenantDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TenantDto> getTenantWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getTenantValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<TenantDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Tenant (asynchronously)
     * Retrieves a tenant.
     * @param id The id of the tenant to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Tenant with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTenantAsync(String id, final ApiCallback<TenantDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTenantValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TenantDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTenantCount
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTenantCountCall(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (userMember != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userMember", userMember));
        }

        if (groupMember != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupMember", groupMember));
        }

        if (includingGroupsOfUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includingGroupsOfUser", includingGroupsOfUser));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTenantCountValidateBeforeCall(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getTenantCountCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        return localVarCall;

    }

    /**
     * Get Tenant Count
     * Query for tenants using a list of parameters and retrieves the count.
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getTenantCount(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getTenantCountWithHttpInfo(id, name, nameLike, userMember, groupMember, includingGroupsOfUser);
        return localVarResp.getData();
    }

    /**
     * Get Tenant Count
     * Query for tenants using a list of parameters and retrieves the count.
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getTenantCountWithHttpInfo(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        okhttp3.Call localVarCall = getTenantCountValidateBeforeCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Tenant Count (asynchronously)
     * Query for tenants using a list of parameters and retrieves the count.
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTenantCountAsync(String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTenantCountValidateBeforeCall(id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryTenants
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryTenantsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tenant";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (userMember != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userMember", userMember));
        }

        if (groupMember != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupMember", groupMember));
        }

        if (includingGroupsOfUser != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includingGroupsOfUser", includingGroupsOfUser));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryTenantsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryTenantsCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        return localVarCall;

    }

    /**
     * Get Tenants
     * Query for a list of tenants using a list of parameters. The size of the result set can be retrieved by using the [Get Tenant Count](https://docs.camunda.org/manual/7.22/reference/rest/tenant/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return List&lt;TenantDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<TenantDto> queryTenants(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        ApiResponse<List<TenantDto>> localVarResp = queryTenantsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser);
        return localVarResp.getData();
    }

    /**
     * Get Tenants
     * Query for a list of tenants using a list of parameters. The size of the result set can be retrieved by using the [Get Tenant Count](https://docs.camunda.org/manual/7.22/reference/rest/tenant/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;List&lt;TenantDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TenantDto>> queryTenantsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser) throws ApiException {
        okhttp3.Call localVarCall = queryTenantsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, null);
        Type localVarReturnType = new TypeToken<List<TenantDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Tenants (asynchronously)
     * Query for a list of tenants using a list of parameters. The size of the result set can be retrieved by using the [Get Tenant Count](https://docs.camunda.org/manual/7.22/reference/rest/tenant/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param id Filter by the id of the tenant. (optional)
     * @param name Filter by the name of the tenant. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param userMember Select only tenants where the given user is a member of. (optional)
     * @param groupMember Select only tenants where the given group is a member of. (optional)
     * @param includingGroupsOfUser Select only tenants where the user or one of his groups is a member of. Can only be used in combination with the &#x60;userMember&#x60; parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryTenantsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String name, String nameLike, String userMember, String groupMember, Boolean includingGroupsOfUser, final ApiCallback<List<TenantDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryTenantsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, name, nameLike, userMember, groupMember, includingGroupsOfUser, _callback);
        Type localVarReturnType = new TypeToken<List<TenantDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTenant
     * @param id The id of the tenant. (required)
     * @param tenantDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> If the tenant with the requested Id cannot be found. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be updated due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTenantCall(String id, TenantDto tenantDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = tenantDto;

        // create path and map variables
        String localVarPath = "/tenant/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTenantValidateBeforeCall(String id, TenantDto tenantDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTenant(Async)");
        }
        

        okhttp3.Call localVarCall = updateTenantCall(id, tenantDto, _callback);
        return localVarCall;

    }

    /**
     * Update Tenant
     * Updates a given tenant.
     * @param id The id of the tenant. (required)
     * @param tenantDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> If the tenant with the requested Id cannot be found. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be updated due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateTenant(String id, TenantDto tenantDto) throws ApiException {
        updateTenantWithHttpInfo(id, tenantDto);
    }

    /**
     * Update Tenant
     * Updates a given tenant.
     * @param id The id of the tenant. (required)
     * @param tenantDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> If the tenant with the requested Id cannot be found. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be updated due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateTenantWithHttpInfo(String id, TenantDto tenantDto) throws ApiException {
        okhttp3.Call localVarCall = updateTenantValidateBeforeCall(id, tenantDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update Tenant (asynchronously)
     * Updates a given tenant.
     * @param id The id of the tenant. (required)
     * @param tenantDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Identity service is read-only. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> If the tenant with the requested Id cannot be found. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The tenant could not be updated due to an internal server error. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTenantAsync(String id, TenantDto tenantDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTenantValidateBeforeCall(id, tenantDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
