/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.BatchDto;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.MigrationExecutionDto;
import org.openapitools.client.model.MigrationPlanDto;
import org.openapitools.client.model.MigrationPlanGenerationDto;
import org.openapitools.client.model.MigrationPlanReportDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MigrationApi {
    private ApiClient localVarApiClient;

    public MigrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MigrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for executeMigrationPlan
     * @param migrationExecutionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * The provided migration plan is not valid for a specific process instance it is applied to, so an exception of type &#x60;MigratingProcessInstanceValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeMigrationPlanCall(MigrationExecutionDto migrationExecutionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = migrationExecutionDto;

        // create path and map variables
        String localVarPath = "/migration/execute";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeMigrationPlanValidateBeforeCall(MigrationExecutionDto migrationExecutionDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = executeMigrationPlanCall(migrationExecutionDto, _callback);
        return localVarCall;

    }

    /**
     * Execute Migration Plan
     * Executes a migration plan synchronously for multiple process instances. To execute a migration plan asynchronously, use the [Execute Migration Plan Async(Batch)](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration-async/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * The provided migration plan is not valid for a specific process instance it is applied to, so an exception of type &#x60;MigratingProcessInstanceValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void executeMigrationPlan(MigrationExecutionDto migrationExecutionDto) throws ApiException {
        executeMigrationPlanWithHttpInfo(migrationExecutionDto);
    }

    /**
     * Execute Migration Plan
     * Executes a migration plan synchronously for multiple process instances. To execute a migration plan asynchronously, use the [Execute Migration Plan Async(Batch)](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration-async/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * The provided migration plan is not valid for a specific process instance it is applied to, so an exception of type &#x60;MigratingProcessInstanceValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> executeMigrationPlanWithHttpInfo(MigrationExecutionDto migrationExecutionDto) throws ApiException {
        okhttp3.Call localVarCall = executeMigrationPlanValidateBeforeCall(migrationExecutionDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Execute Migration Plan (asynchronously)
     * Executes a migration plan synchronously for multiple process instances. To execute a migration plan asynchronously, use the [Execute Migration Plan Async(Batch)](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration-async/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * The provided migration plan is not valid for a specific process instance it is applied to, so an exception of type &#x60;MigratingProcessInstanceValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeMigrationPlanAsync(MigrationExecutionDto migrationExecutionDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeMigrationPlanValidateBeforeCall(migrationExecutionDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for executeMigrationPlanAsync
     * @param migrationExecutionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeMigrationPlanAsyncCall(MigrationExecutionDto migrationExecutionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = migrationExecutionDto;

        // create path and map variables
        String localVarPath = "/migration/executeAsync";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeMigrationPlanAsyncValidateBeforeCall(MigrationExecutionDto migrationExecutionDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = executeMigrationPlanAsyncCall(migrationExecutionDto, _callback);
        return localVarCall;

    }

    /**
     * Execute Migration Plan Async (Batch)
     * Executes a migration plan asynchronously (batch) for multiple process instances. To execute a migration plan synchronously, use the [Execute MigrationPlan](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto executeMigrationPlanAsync(MigrationExecutionDto migrationExecutionDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = executeMigrationPlanAsyncWithHttpInfo(migrationExecutionDto);
        return localVarResp.getData();
    }

    /**
     * Execute Migration Plan Async (Batch)
     * Executes a migration plan asynchronously (batch) for multiple process instances. To execute a migration plan synchronously, use the [Execute MigrationPlan](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> executeMigrationPlanAsyncWithHttpInfo(MigrationExecutionDto migrationExecutionDto) throws ApiException {
        okhttp3.Call localVarCall = executeMigrationPlanAsyncValidateBeforeCall(migrationExecutionDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Migration Plan Async (Batch) (asynchronously)
     * Executes a migration plan asynchronously (batch) for multiple process instances. To execute a migration plan synchronously, use the [Execute MigrationPlan](https://docs.camunda.org/manual/7.22/reference/rest/migration/execute-migration/) method.  For more information about the difference between synchronous and asynchronous execution of a migration plan, please refer to the related section of [the user guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#executing-a-migration-plan).
     * @param migrationExecutionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The request is not valid if one or more of the following statements apply:  * The provided migration plan is not valid, so an exception of type &#x60;MigrationPlanValidationException&#x60; is returned. * In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeMigrationPlanAsyncAsync(MigrationExecutionDto migrationExecutionDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeMigrationPlanAsyncValidateBeforeCall(migrationExecutionDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for generateMigrationPlan
     * @param migrationPlanGenerationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The requested migration was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call generateMigrationPlanCall(MigrationPlanGenerationDto migrationPlanGenerationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = migrationPlanGenerationDto;

        // create path and map variables
        String localVarPath = "/migration/generate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call generateMigrationPlanValidateBeforeCall(MigrationPlanGenerationDto migrationPlanGenerationDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = generateMigrationPlanCall(migrationPlanGenerationDto, _callback);
        return localVarCall;

    }

    /**
     * Generate Migration Plan
     * Generates a migration plan for two process definitions. The generated migration plan contains migration instructions which map equal activities between the two process definitions.
     * @param migrationPlanGenerationDto  (optional)
     * @return MigrationPlanDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The requested migration was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public MigrationPlanDto generateMigrationPlan(MigrationPlanGenerationDto migrationPlanGenerationDto) throws ApiException {
        ApiResponse<MigrationPlanDto> localVarResp = generateMigrationPlanWithHttpInfo(migrationPlanGenerationDto);
        return localVarResp.getData();
    }

    /**
     * Generate Migration Plan
     * Generates a migration plan for two process definitions. The generated migration plan contains migration instructions which map equal activities between the two process definitions.
     * @param migrationPlanGenerationDto  (optional)
     * @return ApiResponse&lt;MigrationPlanDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The requested migration was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MigrationPlanDto> generateMigrationPlanWithHttpInfo(MigrationPlanGenerationDto migrationPlanGenerationDto) throws ApiException {
        okhttp3.Call localVarCall = generateMigrationPlanValidateBeforeCall(migrationPlanGenerationDto, null);
        Type localVarReturnType = new TypeToken<MigrationPlanDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate Migration Plan (asynchronously)
     * Generates a migration plan for two process definitions. The generated migration plan contains migration instructions which map equal activities between the two process definitions.
     * @param migrationPlanGenerationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The requested migration was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call generateMigrationPlanAsync(MigrationPlanGenerationDto migrationPlanGenerationDto, final ApiCallback<MigrationPlanDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = generateMigrationPlanValidateBeforeCall(migrationPlanGenerationDto, _callback);
        Type localVarReturnType = new TypeToken<MigrationPlanDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for validateMigrationPlan
     * @param migrationPlanDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The validation report was returned. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateMigrationPlanCall(MigrationPlanDto migrationPlanDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = migrationPlanDto;

        // create path and map variables
        String localVarPath = "/migration/validate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call validateMigrationPlanValidateBeforeCall(MigrationPlanDto migrationPlanDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = validateMigrationPlanCall(migrationPlanDto, _callback);
        return localVarCall;

    }

    /**
     * Validate Migration Plan
     * Validates a migration plan statically without executing it. This corresponds to the [creation time validation](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#creation-time-validation) described in the user guide.
     * @param migrationPlanDto  (optional)
     * @return MigrationPlanReportDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The validation report was returned. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public MigrationPlanReportDto validateMigrationPlan(MigrationPlanDto migrationPlanDto) throws ApiException {
        ApiResponse<MigrationPlanReportDto> localVarResp = validateMigrationPlanWithHttpInfo(migrationPlanDto);
        return localVarResp.getData();
    }

    /**
     * Validate Migration Plan
     * Validates a migration plan statically without executing it. This corresponds to the [creation time validation](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#creation-time-validation) described in the user guide.
     * @param migrationPlanDto  (optional)
     * @return ApiResponse&lt;MigrationPlanReportDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The validation report was returned. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MigrationPlanReportDto> validateMigrationPlanWithHttpInfo(MigrationPlanDto migrationPlanDto) throws ApiException {
        okhttp3.Call localVarCall = validateMigrationPlanValidateBeforeCall(migrationPlanDto, null);
        Type localVarReturnType = new TypeToken<MigrationPlanReportDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Validate Migration Plan (asynchronously)
     * Validates a migration plan statically without executing it. This corresponds to the [creation time validation](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-migration/#creation-time-validation) described in the user guide.
     * @param migrationPlanDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The validation report was returned. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> In case additional parameters of the request are unexpected, an exception of type &#x60;InvalidRequestException&#x60; is returned. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateMigrationPlanAsync(MigrationPlanDto migrationPlanDto, final ApiCallback<MigrationPlanReportDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = validateMigrationPlanValidateBeforeCall(migrationPlanDto, _callback);
        Type localVarReturnType = new TypeToken<MigrationPlanReportDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
