/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.BatchDto;
import org.openapitools.client.model.CountResultDto;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.JobDto;
import org.openapitools.client.model.JobDuedateDto;
import org.openapitools.client.model.JobQueryDto;
import org.openapitools.client.model.JobRetriesDto;
import org.openapitools.client.model.JobSuspensionStateDto;
import org.openapitools.client.model.PriorityDto;
import org.openapitools.client.model.SetJobRetriesDto;
import org.openapitools.client.model.SuspensionStateDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobApi {
    private ApiClient localVarApiClient;

    public JobApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JobApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteJob
     * @param id The id of the job to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be deleted. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteJobCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteJobValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteJob(Async)");
        }
        

        okhttp3.Call localVarCall = deleteJobCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Job
     * Deletes a job by id.
     * @param id The id of the job to be deleted. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be deleted. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteJob(String id) throws ApiException {
        deleteJobWithHttpInfo(id);
    }

    /**
     * Delete Job
     * Deletes a job by id.
     * @param id The id of the job to be deleted. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be deleted. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteJobWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteJobValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Job (asynchronously)
     * Deletes a job by id.
     * @param id The id of the job to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be deleted. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteJobAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteJobValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for executeJob
     * @param id The id of the job to be executed. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be executed successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeJobCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/{id}/execute"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeJobValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeJob(Async)");
        }
        

        okhttp3.Call localVarCall = executeJobCall(id, _callback);
        return localVarCall;

    }

    /**
     * Execute Job
     * Executes a job by id. **Note:** The execution of the job happens synchronously in the same thread.
     * @param id The id of the job to be executed. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be executed successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void executeJob(String id) throws ApiException {
        executeJobWithHttpInfo(id);
    }

    /**
     * Execute Job
     * Executes a job by id. **Note:** The execution of the job happens synchronously in the same thread.
     * @param id The id of the job to be executed. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be executed successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> executeJobWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = executeJobValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Execute Job (asynchronously)
     * Executes a job by id. **Note:** The execution of the job happens synchronously in the same thread.
     * @param id The id of the job to be executed. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The job could not be executed successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeJobAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeJobValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJob
     * @param id The id of the job to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getJob(Async)");
        }
        

        okhttp3.Call localVarCall = getJobCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Job
     * Retrieves a job by id, according to the &#x60;Job&#x60; interface in the engine.
     * @param id The id of the job to be retrieved. (required)
     * @return JobDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public JobDto getJob(String id) throws ApiException {
        ApiResponse<JobDto> localVarResp = getJobWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Job
     * Retrieves a job by id, according to the &#x60;Job&#x60; interface in the engine.
     * @param id The id of the job to be retrieved. (required)
     * @return ApiResponse&lt;JobDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<JobDto> getJobWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getJobValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<JobDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job (asynchronously)
     * Retrieves a job by id, according to the &#x60;Job&#x60; interface in the engine.
     * @param id The id of the job to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobAsync(String id, final ApiCallback<JobDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<JobDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJobs
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobsCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobIds", jobIds));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }

        if (executable != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executable", executable));
        }

        if (timers != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timers", timers));
        }

        if (messages != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("messages", messages));
        }

        if (dueDates != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dueDates", dueDates));
        }

        if (createTimes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimes", createTimes));
        }

        if (withException != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withException", withException));
        }

        if (exceptionMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("exceptionMessage", exceptionMessage));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }

        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeJobsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobsValidateBeforeCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getJobsCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Jobs
     * Queries for jobs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;JobDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<JobDto>> localVarResp = getJobsWithHttpInfo(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Jobs
     * Queries for jobs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;JobDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<JobDto>> getJobsWithHttpInfo(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getJobsValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Jobs (asynchronously)
     * Queries for jobs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobsAsync(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<JobDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobsValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJobsCount
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobsCountCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobIds", jobIds));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }

        if (executable != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executable", executable));
        }

        if (timers != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timers", timers));
        }

        if (messages != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("messages", messages));
        }

        if (dueDates != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dueDates", dueDates));
        }

        if (createTimes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createTimes", createTimes));
        }

        if (withException != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withException", withException));
        }

        if (exceptionMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("exceptionMessage", exceptionMessage));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }

        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeJobsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobsCountValidateBeforeCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getJobsCountCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Job Count
     * Queries for the number of jobs that fulfill given parameters. Takes the same parameters as the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getJobsCountWithHttpInfo(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get Job Count
     * Queries for the number of jobs that fulfill given parameters. Takes the same parameters as the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getJobsCountWithHttpInfo(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getJobsCountValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Count (asynchronously)
     * Queries for the number of jobs that fulfill given parameters. Takes the same parameters as the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method.
     * @param jobId Filter by job id. (optional)
     * @param jobIds Filter by a comma-separated list of job ids. (optional)
     * @param jobDefinitionId Only select jobs which exist for the given job definition. (optional)
     * @param processInstanceId Only select jobs which exist for the given process instance. (optional)
     * @param processInstanceIds Only select jobs which exist for the given comma-separated list of process instance ids. (optional)
     * @param executionId Only select jobs which exist for the given execution. (optional)
     * @param processDefinitionId Filter by the id of the process definition the jobs run on. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the jobs run on. (optional)
     * @param activityId Only select jobs which exist for an activity with the given id. (optional)
     * @param withRetriesLeft Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param executable Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param timers Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param messages Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param dueDates Only select jobs where the due date is lower or higher than the given date. Due date expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param createTimes Only select jobs created before or after the given date.  Create time expressions are comma-separated and are structured as follows:  A valid condition value has the form &#x60;operator_value&#x60;. &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the date value as string.  Valid operator values are: &#x60;gt&#x60; - greater than; &#x60;lt&#x60; - lower than. &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param withException Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param exceptionMessage Only select jobs that failed due to an exception with the given message. (optional)
     * @param failedActivityId Only select jobs that failed due to an exception at an activity with the given id. (optional)
     * @param noRetriesLeft Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param active Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param tenantIdIn Only include jobs which belong to one of the passed comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobsWithoutTenantId Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobsCountAsync(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobsCountValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStacktrace
     * @param id The id of the job to get the exception stacktrace for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStacktraceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/{id}/stacktrace"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStacktraceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStacktrace(Async)");
        }
        

        okhttp3.Call localVarCall = getStacktraceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Exception Stacktrace
     * Retrieves the exception stacktrace corresponding to the passed job id.
     * @param id The id of the job to get the exception stacktrace for. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Object getStacktrace(String id) throws ApiException {
        ApiResponse<Object> localVarResp = getStacktraceWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Exception Stacktrace
     * Retrieves the exception stacktrace corresponding to the passed job id.
     * @param id The id of the job to get the exception stacktrace for. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getStacktraceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getStacktraceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Exception Stacktrace (asynchronously)
     * Retrieves the exception stacktrace corresponding to the passed job id.
     * @param id The id of the job to get the exception stacktrace for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStacktraceAsync(String id, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStacktraceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryJobs
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobsCall(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobQueryDto;

        // create path and map variables
        String localVarPath = "/job";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryJobsValidateBeforeCall(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryJobsCall(firstResult, maxResults, jobQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Jobs (POST)
     * Queries for jobs that fulfill given parameters. This method is slightly more powerful than the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method because it allows filtering by multiple jobs of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobQueryDto  (optional)
     * @return List&lt;JobDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
        ApiResponse<List<JobDto>> localVarResp = queryJobsWithHttpInfo(firstResult, maxResults, jobQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Jobs (POST)
     * Queries for jobs that fulfill given parameters. This method is slightly more powerful than the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method because it allows filtering by multiple jobs of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;JobDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<JobDto>> queryJobsWithHttpInfo(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryJobsValidateBeforeCall(firstResult, maxResults, jobQueryDto, null);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Jobs (POST) (asynchronously)
     * Queries for jobs that fulfill given parameters. This method is slightly more powerful than the [Get Jobs](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query/) method because it allows filtering by multiple jobs of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobsAsync(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, final ApiCallback<List<JobDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryJobsValidateBeforeCall(firstResult, maxResults, jobQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryJobsCount
     * @param jobQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobsCountCall(JobQueryDto jobQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobQueryDto;

        // create path and map variables
        String localVarPath = "/job/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryJobsCountValidateBeforeCall(JobQueryDto jobQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryJobsCountCall(jobQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Job Count (POST)
     * Queries for jobs that fulfill given parameters. This method takes the same message body as the [Get Jobs POST](https://docs.camunda.org/manual/7.22/reference/rest/job/post- query/) method and therefore it is slightly more powerful than the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryJobsCount(JobQueryDto jobQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryJobsCountWithHttpInfo(jobQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Job Count (POST)
     * Queries for jobs that fulfill given parameters. This method takes the same message body as the [Get Jobs POST](https://docs.camunda.org/manual/7.22/reference/rest/job/post- query/) method and therefore it is slightly more powerful than the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryJobsCountWithHttpInfo(JobQueryDto jobQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryJobsCountValidateBeforeCall(jobQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Count (POST) (asynchronously)
     * Queries for jobs that fulfill given parameters. This method takes the same message body as the [Get Jobs POST](https://docs.camunda.org/manual/7.22/reference/rest/job/post- query/) method and therefore it is slightly more powerful than the [Get Job Count](https://docs.camunda.org/manual/7.22/reference/rest/job/get-query-count/) method.
     * @param jobQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example, if an invalid operator for due date comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobsCountAsync(JobQueryDto jobQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryJobsCountValidateBeforeCall(jobQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for recalculateDuedate
     * @param id The id of the job to be updated. (required)
     * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be recalculated successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call recalculateDuedateCall(String id, Boolean creationDateBased, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job/{id}/duedate/recalculate"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (creationDateBased != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creationDateBased", creationDateBased));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call recalculateDuedateValidateBeforeCall(String id, Boolean creationDateBased, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling recalculateDuedate(Async)");
        }
        

        okhttp3.Call localVarCall = recalculateDuedateCall(id, creationDateBased, _callback);
        return localVarCall;

    }

    /**
     * Recalculate Job Due Date
     * Recalculates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be recalculated successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void recalculateDuedate(String id, Boolean creationDateBased) throws ApiException {
        recalculateDuedateWithHttpInfo(id, creationDateBased);
    }

    /**
     * Recalculate Job Due Date
     * Recalculates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be recalculated successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> recalculateDuedateWithHttpInfo(String id, Boolean creationDateBased) throws ApiException {
        okhttp3.Call localVarCall = recalculateDuedateValidateBeforeCall(id, creationDateBased, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Recalculate Job Due Date (asynchronously)
     * Recalculates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param creationDateBased Recalculate the due date based on the creation date of the job or the current date. Value may only be &#x60;false&#x60;, as &#x60;true&#x60; is the default behavior.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be recalculated successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call recalculateDuedateAsync(String id, Boolean creationDateBased, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = recalculateDuedateValidateBeforeCall(id, creationDateBased, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobDuedate
     * @param id The id of the job to be updated. (required)
     * @param jobDuedateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobDuedateCall(String id, JobDuedateDto jobDuedateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDuedateDto;

        // create path and map variables
        String localVarPath = "/job/{id}/duedate"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobDuedateValidateBeforeCall(String id, JobDuedateDto jobDuedateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobDuedate(Async)");
        }
        

        okhttp3.Call localVarCall = setJobDuedateCall(id, jobDuedateDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Due Date
     * Updates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param jobDuedateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setJobDuedate(String id, JobDuedateDto jobDuedateDto) throws ApiException {
        setJobDuedateWithHttpInfo(id, jobDuedateDto);
    }

    /**
     * Set Job Due Date
     * Updates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param jobDuedateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setJobDuedateWithHttpInfo(String id, JobDuedateDto jobDuedateDto) throws ApiException {
        okhttp3.Call localVarCall = setJobDuedateValidateBeforeCall(id, jobDuedateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Job Due Date (asynchronously)
     * Updates the due date of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param jobDuedateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The due date could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobDuedateAsync(String id, JobDuedateDto jobDuedateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobDuedateValidateBeforeCall(id, jobDuedateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobPriority
     * @param id The id of the job to be updated. (required)
     * @param priorityDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The priority could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobPriorityCall(String id, PriorityDto priorityDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = priorityDto;

        // create path and map variables
        String localVarPath = "/job/{id}/priority"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobPriorityValidateBeforeCall(String id, PriorityDto priorityDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobPriority(Async)");
        }
        

        okhttp3.Call localVarCall = setJobPriorityCall(id, priorityDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Priority
     * Sets the execution priority of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param priorityDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The priority could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setJobPriority(String id, PriorityDto priorityDto) throws ApiException {
        setJobPriorityWithHttpInfo(id, priorityDto);
    }

    /**
     * Set Job Priority
     * Sets the execution priority of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param priorityDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The priority could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setJobPriorityWithHttpInfo(String id, PriorityDto priorityDto) throws ApiException {
        okhttp3.Call localVarCall = setJobPriorityValidateBeforeCall(id, priorityDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Job Priority (asynchronously)
     * Sets the execution priority of a job by id.
     * @param id The id of the job to be updated. (required)
     * @param priorityDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The priority could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobPriorityAsync(String id, PriorityDto priorityDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobPriorityValidateBeforeCall(id, priorityDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobRetries
     * @param id The id of the job to be updated. (required)
     * @param jobRetriesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesCall(String id, JobRetriesDto jobRetriesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobRetriesDto;

        // create path and map variables
        String localVarPath = "/job/{id}/retries"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobRetriesValidateBeforeCall(String id, JobRetriesDto jobRetriesDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobRetries(Async)");
        }
        

        okhttp3.Call localVarCall = setJobRetriesCall(id, jobRetriesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Retries
     * Sets the retries of the job to the given number of retries by id.
     * @param id The id of the job to be updated. (required)
     * @param jobRetriesDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setJobRetries(String id, JobRetriesDto jobRetriesDto) throws ApiException {
        setJobRetriesWithHttpInfo(id, jobRetriesDto);
    }

    /**
     * Set Job Retries
     * Sets the retries of the job to the given number of retries by id.
     * @param id The id of the job to be updated. (required)
     * @param jobRetriesDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setJobRetriesWithHttpInfo(String id, JobRetriesDto jobRetriesDto) throws ApiException {
        okhttp3.Call localVarCall = setJobRetriesValidateBeforeCall(id, jobRetriesDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Job Retries (asynchronously)
     * Sets the retries of the job to the given number of retries by id.
     * @param id The id of the job to be updated. (required)
     * @param jobRetriesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesAsync(String id, JobRetriesDto jobRetriesDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobRetriesValidateBeforeCall(id, jobRetriesDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobRetriesAsyncOperation
     * @param setJobRetriesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if neither processInstanceIds nor processInstanceQuery is present. Or if the retry count is not specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesAsyncOperationCall(SetJobRetriesDto setJobRetriesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setJobRetriesDto;

        // create path and map variables
        String localVarPath = "/job/retries";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobRetriesAsyncOperationValidateBeforeCall(SetJobRetriesDto setJobRetriesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setJobRetriesAsyncOperationCall(setJobRetriesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Retries Async (POST)
     * Create a batch to set retries of jobs asynchronously.
     * @param setJobRetriesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if neither processInstanceIds nor processInstanceQuery is present. Or if the retry count is not specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setJobRetriesAsyncOperationWithHttpInfo(setJobRetriesDto);
        return localVarResp.getData();
    }

    /**
     * Set Job Retries Async (POST)
     * Create a batch to set retries of jobs asynchronously.
     * @param setJobRetriesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if neither processInstanceIds nor processInstanceQuery is present. Or if the retry count is not specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setJobRetriesAsyncOperationWithHttpInfo(SetJobRetriesDto setJobRetriesDto) throws ApiException {
        okhttp3.Call localVarCall = setJobRetriesAsyncOperationValidateBeforeCall(setJobRetriesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Job Retries Async (POST) (asynchronously)
     * Create a batch to set retries of jobs asynchronously.
     * @param setJobRetriesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if neither processInstanceIds nor processInstanceQuery is present. Or if the retry count is not specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesAsyncOperationAsync(SetJobRetriesDto setJobRetriesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobRetriesAsyncOperationValidateBeforeCall(setJobRetriesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateJobSuspensionState
     * @param id The id of the job to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateJobSuspensionStateCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = suspensionStateDto;

        // create path and map variables
        String localVarPath = "/job/{id}/suspended"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateJobSuspensionStateValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateJobSuspensionState(Async)");
        }
        

        okhttp3.Call localVarCall = updateJobSuspensionStateCall(id, suspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend Job By Id
     * Activates or suspends a given job by id.
     * @param id The id of the job to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
     </table>
     */
    public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        updateJobSuspensionStateWithHttpInfo(id, suspensionStateDto);
    }

    /**
     * Activate/Suspend Job By Id
     * Activates or suspends a given job by id.
     * @param id The id of the job to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateJobSuspensionStateWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateJobSuspensionStateValidateBeforeCall(id, suspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend Job By Id (asynchronously)
     * Activates or suspends a given job by id.
     * @param id The id of the job to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateJobSuspensionStateAsync(String id, SuspensionStateDto suspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateJobSuspensionStateValidateBeforeCall(id, suspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionStateBy
     * @param jobSuspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request parameters are invalid, for example, if &#x60;jobDefinitionId&#x60; and &#x60;processDefinitionId&#x60; are both specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateByCall(JobSuspensionStateDto jobSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/job/suspended";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateByValidateBeforeCall(JobSuspensionStateDto jobSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = updateSuspensionStateByCall(jobSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend Jobs
     * Activates or suspends jobs matching the given criterion. This can only be on of: * &#x60;jobDefinitionId&#x60; * &#x60;processDefinitionId&#x60; * &#x60;processInstanceId&#x60; * &#x60;processDefinitionKey&#x60;
     * @param jobSuspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request parameters are invalid, for example, if &#x60;jobDefinitionId&#x60; and &#x60;processDefinitionId&#x60; are both specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
        updateSuspensionStateByWithHttpInfo(jobSuspensionStateDto);
    }

    /**
     * Activate/Suspend Jobs
     * Activates or suspends jobs matching the given criterion. This can only be on of: * &#x60;jobDefinitionId&#x60; * &#x60;processDefinitionId&#x60; * &#x60;processInstanceId&#x60; * &#x60;processDefinitionKey&#x60;
     * @param jobSuspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request parameters are invalid, for example, if &#x60;jobDefinitionId&#x60; and &#x60;processDefinitionId&#x60; are both specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSuspensionStateByWithHttpInfo(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateByValidateBeforeCall(jobSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend Jobs (asynchronously)
     * Activates or suspends jobs matching the given criterion. This can only be on of: * &#x60;jobDefinitionId&#x60; * &#x60;processDefinitionId&#x60; * &#x60;processInstanceId&#x60; * &#x60;processDefinitionKey&#x60;
     * @param jobSuspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request parameters are invalid, for example, if &#x60;jobDefinitionId&#x60; and &#x60;processDefinitionId&#x60; are both specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateByAsync(JobSuspensionStateDto jobSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateByValidateBeforeCall(jobSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
