/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CountResultDto;
import org.openapitools.client.model.DecisionRequirementsDefinitionDto;
import org.openapitools.client.model.DecisionRequirementsDefinitionXmlDto;
import org.openapitools.client.model.ExceptionDto;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecisionRequirementsDefinitionApi {
    private ApiClient localVarApiClient;

    public DecisionRequirementsDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DecisionRequirementsDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getDecisionRequirementsDefinitionById
     * @param id The id of the decision requirements definition to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionById(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Definition by ID
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.
     * @param id The id of the decision requirements definition to be retrieved. (required)
     * @return DecisionRequirementsDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionById(String id) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionDto> localVarResp = getDecisionRequirementsDefinitionByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Definition by ID
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.
     * @param id The id of the decision requirements definition to be retrieved. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitionByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Definition by ID (asynchronously)
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.
     * @param id The id of the decision requirements definition to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByIdAsync(String id, final ApiCallback<DecisionRequirementsDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionByKey
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Definition by Key
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return DecisionRequirementsDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKey(String key) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionDto> localVarResp = getDecisionRequirementsDefinitionByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Definition by Key
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitionByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Definition by Key (asynchronously)
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByKeyAsync(String key, final ApiCallback<DecisionRequirementsDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionByKeyAndTenantId
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Definition by Key and Tenant ID
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return DecisionRequirementsDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionDto> localVarResp = getDecisionRequirementsDefinitionByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Definition by Key and Tenant ID
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitionByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Definition by Key and Tenant ID (asynchronously)
     * Retrieves a decision requirements definition according to the &#x60;DecisionRequirementsDefinition&#x60; interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<DecisionRequirementsDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDiagramById
     * @param id The id of the decision requirements definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/{id}/diagram"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "image/_*", "application/octet-stream", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDiagramByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionDiagramById(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Diagram by ID
     * Retrieves the diagram of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionRequirementsDefinitionDiagramById(String id) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionRequirementsDefinitionDiagramByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Diagram by ID
     * Retrieves the diagram of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionRequirementsDefinitionDiagramByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Diagram by ID (asynchronously)
     * Retrieves the diagram of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByIdAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDiagramByKey
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "image/_*", "application/octet-stream", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDiagramByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Diagram by Key
     * Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionRequirementsDefinitionDiagramByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionRequirementsDefinitionDiagramByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Diagram by Key
     * Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionRequirementsDefinitionDiagramByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Diagram by Key (asynchronously)
     * Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyAsync(String key, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDiagramByKeyAndTenantId
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "image/_*", "application/octet-stream", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Diagram by Key and Tenant ID
     * Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionRequirementsDefinitionDiagramByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Diagram by Key and Tenant ID
     * Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Diagram by Key and Tenant ID (asynchronously)
     * Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The image diagram of the decision requirements definition. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision requirements definition doesn&#39;t have an associated diagram. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDmnXmlById
     * @param id The id of the decision requirements definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/{id}/xml"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionRequirementsDefinitionDmnXmlById(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get DMN XML by ID
     * Retrieves the DMN XML of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @return DecisionRequirementsDefinitionXmlDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlById(String id) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionXmlDto> localVarResp = getDecisionRequirementsDefinitionDmnXmlByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get DMN XML by ID
     * Retrieves the DMN XML of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionXmlDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionXmlDto> getDecisionRequirementsDefinitionDmnXmlByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get DMN XML by ID (asynchronously)
     * Retrieves the DMN XML of a decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByIdAsync(String id, final ApiCallback<DecisionRequirementsDefinitionXmlDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDmnXmlByKey
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDmnXmlByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get DMN XML by Key
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return DecisionRequirementsDefinitionXmlDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKey(String key) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionXmlDto> localVarResp = getDecisionRequirementsDefinitionDmnXmlByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get DMN XML by Key
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionXmlDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionXmlDto> getDecisionRequirementsDefinitionDmnXmlByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get DMN XML by Key (asynchronously)
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyAsync(String key, final ApiCallback<DecisionRequirementsDefinitionXmlDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get DMN XML by Key and Tenant ID
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return DecisionRequirementsDefinitionXmlDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionRequirementsDefinitionXmlDto> localVarResp = getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get DMN XML by Key and Tenant ID
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @return ApiResponse&lt;DecisionRequirementsDefinitionXmlDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionRequirementsDefinitionXmlDto> getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get DMN XML by Key and Tenant ID (asynchronously)
     * Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.
     * @param key The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant to which the decision requirements definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Decision requirements definition with given id or key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<DecisionRequirementsDefinitionXmlDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionDmnXmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionRequirementsDefinitionXmlDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitions
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionsCall(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionIdIn", decisionRequirementsDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeDecisionRequirementsDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDecisionRequirementsDefinitionsWithoutTenantId", includeDecisionRequirementsDefinitionsWithoutTenantId));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionsValidateBeforeCall(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Definitions
     * Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query-count/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;DecisionRequirementsDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitions(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<DecisionRequirementsDefinitionDto>> localVarResp = getDecisionRequirementsDefinitionsWithHttpInfo(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Definitions
     * Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query-count/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;DecisionRequirementsDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<DecisionRequirementsDefinitionDto>> getDecisionRequirementsDefinitionsWithHttpInfo(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsValidateBeforeCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<DecisionRequirementsDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Definitions (asynchronously)
     * Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query-count/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionsAsync(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<DecisionRequirementsDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsValidateBeforeCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<DecisionRequirementsDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionRequirementsDefinitionsCount
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionsCountCall(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-requirements-definition/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionIdIn", decisionRequirementsDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeDecisionRequirementsDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDecisionRequirementsDefinitionsWithoutTenantId", includeDecisionRequirementsDefinitionsWithoutTenantId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionRequirementsDefinitionsCountValidateBeforeCall(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsCountCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Requirements Definition Count
     * Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getDecisionRequirementsDefinitionsCount(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getDecisionRequirementsDefinitionsCountWithHttpInfo(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get Decision Requirements Definition Count
     * Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getDecisionRequirementsDefinitionsCountWithHttpInfo(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsCountValidateBeforeCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Requirements Definition Count (asynchronously)
     * Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.22/reference/rest/decision-requirements-definition/get-query/) method.
     * @param decisionRequirementsDefinitionId Filter by decision requirements definition id. (optional)
     * @param decisionRequirementsDefinitionIdIn Filter by decision requirements definition ids. (optional)
     * @param name Filter by decision requirements definition name. (optional)
     * @param nameLike Filter by decision requirements definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the id of the deployment a decision requirement definition belongs to. (optional)
     * @param key Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match. (optional)
     * @param keyLike Filter by decision requirements definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision requirements definition category. Exact match. (optional)
     * @param categoryLike Filter by decision requirements definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision requirements definition version. (optional)
     * @param latestVersion Only include those decision requirements definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision requirements definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision requirements definition resources that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision requirements definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionRequirementsDefinitionsWithoutTenantId Include decision requirements definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionRequirementsDefinitionsCountAsync(String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionIdIn, String name, String nameLike, String deploymentId, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionRequirementsDefinitionsWithoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionRequirementsDefinitionsCountValidateBeforeCall(decisionRequirementsDefinitionId, decisionRequirementsDefinitionIdIn, name, nameLike, deploymentId, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, tenantIdIn, withoutTenantId, includeDecisionRequirementsDefinitionsWithoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
