/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.BatchDto;
import org.openapitools.client.model.BatchStatisticsDto;
import org.openapitools.client.model.CountResultDto;
import java.util.Date;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.SuspensionStateDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchApi {
    private ApiClient localVarApiClient;

    public BatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteBatch
     * @param id The id of the batch to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteBatchCall(String id, Boolean cascade, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (cascade != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cascade", cascade));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteBatchValidateBeforeCall(String id, Boolean cascade, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteBatch(Async)");
        }
        

        okhttp3.Call localVarCall = deleteBatchCall(id, cascade, _callback);
        return localVarCall;

    }

    /**
     * Delete
     * Deletes a batch by id, including all related jobs and job definitions. Optionally also deletes the batch history.
     * @param id The id of the batch to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteBatch(String id, Boolean cascade) throws ApiException {
        deleteBatchWithHttpInfo(id, cascade);
    }

    /**
     * Delete
     * Deletes a batch by id, including all related jobs and job definitions. Optionally also deletes the batch history.
     * @param id The id of the batch to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteBatchWithHttpInfo(String id, Boolean cascade) throws ApiException {
        okhttp3.Call localVarCall = deleteBatchValidateBeforeCall(id, cascade, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete (asynchronously)
     * Deletes a batch by id, including all related jobs and job definitions. Optionally also deletes the batch history.
     * @param id The id of the batch to be deleted. (required)
     * @param cascade &#x60;true&#x60;, if the historic batch and historic job logs for this batch should also be deleted. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteBatchAsync(String id, Boolean cascade, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteBatchValidateBeforeCall(id, cascade, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBatch
     * @param id The id of the batch to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBatchValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBatch(Async)");
        }
        

        okhttp3.Call localVarCall = getBatchCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves a batch by id, according to the Batch interface in the engine.
     * @param id The id of the batch to be retrieved. (required)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto getBatch(String id) throws ApiException {
        ApiResponse<BatchDto> localVarResp = getBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves a batch by id, according to the Batch interface in the engine.
     * @param id The id of the batch to be retrieved. (required)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> getBatchWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves a batch by id, according to the Batch interface in the engine.
     * @param id The id of the batch to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchAsync(String id, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBatchStatistics
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchStatisticsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch/statistics";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createdBy", createdBy));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (withFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withFailures", withFailures));
        }

        if (withoutFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutFailures", withoutFailures));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBatchStatisticsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBatchStatisticsCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        return localVarCall;

    }

    /**
     * Get Statistics
     * Queries for batch statistics that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the  [Get Batch Statistics Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return List&lt;BatchStatisticsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        ApiResponse<List<BatchStatisticsDto>> localVarResp = getBatchStatisticsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures);
        return localVarResp.getData();
    }

    /**
     * Get Statistics
     * Queries for batch statistics that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the  [Get Batch Statistics Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;BatchStatisticsDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<BatchStatisticsDto>> getBatchStatisticsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        okhttp3.Call localVarCall = getBatchStatisticsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, null);
        Type localVarReturnType = new TypeToken<List<BatchStatisticsDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Statistics (asynchronously)
     * Queries for batch statistics that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the  [Get Batch Statistics Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchStatisticsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback<List<BatchStatisticsDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBatchStatisticsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        Type localVarReturnType = new TypeToken<List<BatchStatisticsDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBatchStatisticsCount
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchStatisticsCountCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch/statistics/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createdBy", createdBy));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (withFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withFailures", withFailures));
        }

        if (withoutFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutFailures", withoutFailures));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBatchStatisticsCountValidateBeforeCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBatchStatisticsCountCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        return localVarCall;

    }

    /**
     * Get Statistics Count
     * Requests the number of batch statistics that fulfill the query criteria. Takes the same filtering parameters as the [Get Batch Statistics](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getBatchStatisticsCountWithHttpInfo(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures);
        return localVarResp.getData();
    }

    /**
     * Get Statistics Count
     * Requests the number of batch statistics that fulfill the query criteria. Takes the same filtering parameters as the [Get Batch Statistics](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getBatchStatisticsCountWithHttpInfo(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        okhttp3.Call localVarCall = getBatchStatisticsCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Statistics Count (asynchronously)
     * Requests the number of batch statistics that fulfill the query criteria. Takes the same filtering parameters as the [Get Batch Statistics](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-statistics-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchStatisticsCountAsync(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBatchStatisticsCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBatches
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createdBy", createdBy));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (withFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withFailures", withFailures));
        }

        if (withoutFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutFailures", withoutFailures));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBatchesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBatchesCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Batch Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return List&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        ApiResponse<List<BatchDto>> localVarResp = getBatchesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Batch Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return ApiResponse&lt;List&lt;BatchDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<BatchDto>> getBatchesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        okhttp3.Call localVarCall = getBatchesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, null);
        Type localVarReturnType = new TypeToken<List<BatchDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Batch Count](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback<List<BatchDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBatchesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        Type localVarReturnType = new TypeToken<List<BatchDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBatchesCount
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchesCountCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/batch/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("createdBy", createdBy));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (withFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withFailures", withFailures));
        }

        if (withoutFailures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutFailures", withoutFailures));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBatchesCountValidateBeforeCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getBatchesCountCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Requests the number of batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Batches](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getBatchesCountWithHttpInfo(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Requests the number of batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Batches](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getBatchesCountWithHttpInfo(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        okhttp3.Call localVarCall = getBatchesCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Requests the number of batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Batches](https://docs.camunda.org/manual/7.22/reference/rest/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended A &#x60;Boolean&#x60; value which indicates whether only active or suspended batches should be included. When the value is set to &#x60;true&#x60;, only suspended batches will be returned and when the value is set to &#x60;false&#x60;, only active batches will be returned. (optional)
     * @param createdBy Only include batches that were started by this user id. (optional)
     * @param startedBefore Only include batches that were started before the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Only include batches that were started after the given date. By [default](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param withFailures Only include batches having jobs with failures. Value can only be &#x60;true&#x60;. (optional)
     * @param withoutFailures Only include batches having jobs without failures. Value can only be &#x60;true&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBatchesCountAsync(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, Date startedBefore, Date startedAfter, Boolean withFailures, Boolean withoutFailures, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBatchesCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateBatchSuspensionState
     * @param id The id of the batch to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the batch cannot be suspended or activated. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateBatchSuspensionStateCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = suspensionStateDto;

        // create path and map variables
        String localVarPath = "/batch/{id}/suspended"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateBatchSuspensionStateValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateBatchSuspensionState(Async)");
        }
        

        okhttp3.Call localVarCall = updateBatchSuspensionStateCall(id, suspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend
     * Activates or suspends a batch by id.
     * @param id The id of the batch to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the batch cannot be suspended or activated. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        updateBatchSuspensionStateWithHttpInfo(id, suspensionStateDto);
    }

    /**
     * Activate/Suspend
     * Activates or suspends a batch by id.
     * @param id The id of the batch to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the batch cannot be suspended or activated. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateBatchSuspensionStateWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateBatchSuspensionStateValidateBeforeCall(id, suspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend (asynchronously)
     * Activates or suspends a batch by id.
     * @param id The id of the batch to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the batch cannot be suspended or activated. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateBatchSuspensionStateAsync(String id, SuspensionStateDto suspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateBatchSuspensionStateValidateBeforeCall(id, suspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
