/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.openapi.generator.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class TemplateParser {
    public static void main(String[] args) throws IOException, TemplateException {
        if (args.length != 4) {
            throw new RuntimeException("Must provide four arguments: <source template directory> <main template> <output directory> <intermediate output dir>");
        }
        String sourceDirectory = args[0];
        String mainTemplate = args[1];
        String outputFile = args[2];
        String debugFile = args[3];
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        cfg.setDirectoryForTemplateLoading(new File(sourceDirectory));
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(mainTemplate);
        Map<String, Object> templateData = TemplateParser.createTemplateData(sourceDirectory);
        try (StringWriter out = new StringWriter();){
            template.process(templateData, (Writer)out);
            String path = TemplateParser.createOutputFile(debugFile);
            FileUtils.forceMkdir((File)new File(debugFile));
            Files.write(Paths.get(path, new String[0]), out.getBuffer().toString().getBytes(), new OpenOption[0]);
            String jsonString = out.getBuffer().toString();
            String formattedJson = TemplateParser.formatJsonString(jsonString);
            File outFile = new File(outputFile);
            FileUtils.forceMkdir((File)outFile.getParentFile());
            Files.write(outFile.toPath(), formattedJson.getBytes(), new OpenOption[0]);
        }
    }

    protected static Map<String, Object> createTemplateData(String sourceDirectory) throws IOException {
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        TemplateParser.resolveVersions(templateData);
        Map<String, String> models = TemplateParser.resolveModels(sourceDirectory);
        templateData.put("models", models);
        Map<String, List<String>> endpoints = TemplateParser.resolvePaths(sourceDirectory);
        templateData.put("endpoints", endpoints);
        return templateData;
    }

    protected static String formatJsonString(String jsonString) {
        Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        JsonParser jsonParser = new JsonParser();
        JsonElement json = jsonParser.parse(jsonString);
        String formattedJson = gson.toJson(json);
        return formattedJson;
    }

    protected static String createOutputFile(String debugFile) throws IOException {
        DateTimeFormatter timeStampPattern = DateTimeFormatter.ofPattern("MM-dd-HH-mm-ss");
        return debugFile + "/intermediate-openapi-" + timeStampPattern.format(LocalDateTime.now()) + ".json";
    }

    protected static void resolveVersions(Map<String, Object> templateData) {
        String version = TemplateParser.class.getPackage().getImplementationVersion();
        if (version != null) {
            templateData.put("cambpmVersion", version);
            if (version.contains("SNAPSHOT")) {
                templateData.put("docsVersion", "develop");
            } else if (version.contains("alpha")) {
                templateData.put("docsVersion", "latest");
            } else {
                templateData.put("docsVersion", version.substring(0, version.lastIndexOf(".")));
            }
        } else {
            templateData.put("cambpmVersion", "develop");
            templateData.put("docsVersion", "develop");
        }
    }

    protected static Map<String, String> resolveModels(String sourceDirectory) {
        File modelsDir = new File(sourceDirectory + "/models");
        Collection modelFiles = FileUtils.listFiles((File)modelsDir, (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        TreeMap<String, String> models = new TreeMap<String, String>();
        for (File file : modelFiles) {
            String modelName = FilenameUtils.removeExtension((String)file.getName());
            String filePath = file.getAbsolutePath();
            String modelPackage = filePath.substring(filePath.lastIndexOf("org"), filePath.lastIndexOf(File.separator));
            models.put(modelName, modelPackage);
        }
        return models;
    }

    protected static Map<String, List<String>> resolvePaths(String sourceDirectory) {
        File endpointsDir = new File(sourceDirectory + "/paths");
        int endpointStartAt = endpointsDir.getAbsolutePath().length();
        Collection endpointsFiles = FileUtils.listFiles((File)endpointsDir, (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        TreeMap<String, List<String>> endpoints = new TreeMap<String, List<String>>();
        for (File file : endpointsFiles) {
            List<String> operations;
            String endpointMethod = FilenameUtils.removeExtension((String)file.getName());
            String filePath = file.getAbsolutePath();
            String endpointPath = filePath.substring(endpointStartAt, filePath.lastIndexOf(File.separator)).replace(File.separator, "/");
            if (endpoints.containsKey(endpointPath)) {
                operations = (List)endpoints.get(endpointPath);
                operations.add(endpointMethod);
            } else {
                operations = new ArrayList();
                operations.add(endpointMethod);
                endpoints.put(endpointPath, operations);
            }
            if (operations.size() <= 1) continue;
            Collections.sort(operations);
        }
        return endpoints;
    }
}

