/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.spin.DataFormats;
import org.camunda.spin.plugin.impl.SpinFunctionMapper;
import org.camunda.spin.plugin.impl.SpinObjectValueSerializer;
import org.camunda.spin.plugin.impl.SpinScriptEnvResolver;
import org.camunda.spin.spi.DataFormat;

public class SpinProcessEnginePlugin
extends AbstractProcessEnginePlugin {
    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ClassLoader classloader = ClassLoaderUtil.getClassloader(SpinProcessEnginePlugin.class);
        DataFormats.loadDataFormats((ClassLoader)classloader);
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.registerFunctionMapper(processEngineConfiguration);
        this.registerScriptResolver(processEngineConfiguration);
        this.registerSerializers(processEngineConfiguration);
    }

    protected void registerSerializers(ProcessEngineConfigurationImpl processEngineConfiguration) {
        List<TypedValueSerializer<?>> spinDataFormatSerializers = this.lookupSpinSerializers();
        VariableSerializers variableSerializers = processEngineConfiguration.getVariableSerializers();
        int javaObjectSerializerIdx = variableSerializers.getSerializerIndexByName("serializable");
        for (TypedValueSerializer<?> spinSerializer : spinDataFormatSerializers) {
            variableSerializers.addSerializer(spinSerializer, javaObjectSerializerIdx);
        }
    }

    protected List<TypedValueSerializer<?>> lookupSpinSerializers() {
        ArrayList serializers = new ArrayList();
        Set availableDataFormats = DataFormats.getAvailableDataFormats();
        for (DataFormat dataFormat : availableDataFormats) {
            serializers.add((TypedValueSerializer<?>)new SpinObjectValueSerializer("spin://" + dataFormat.getName(), dataFormat));
        }
        return serializers;
    }

    protected void registerScriptResolver(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getEnvScriptResolvers().add(new SpinScriptEnvResolver());
    }

    protected void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getExpressionManager().addFunctionMapper((FunctionMapper)new SpinFunctionMapper());
    }
}

