/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.plugin.impl;

import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.connect.ConnectorException;
import org.camunda.connect.Connectors;
import org.camunda.connect.plugin.impl.ConnectorVariableScope;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;
import org.camunda.connect.spi.ConnectorResponse;

public class ServiceTaskConnectorActivityBehavior
extends TaskActivityBehavior {
    protected String connectorId;
    protected Connector<?> connectorInstance;
    protected IoMapping ioMapping;

    public ServiceTaskConnectorActivityBehavior(String connectorId, IoMapping ioMapping) {
        this.connectorId = connectorId;
        this.ioMapping = ioMapping;
    }

    public void execute(ActivityExecution execution) throws Exception {
        this.ensureConnectorInitialized();
        ConnectorRequest request = this.connectorInstance.createRequest();
        try {
            this.applyInputParameters(execution, request);
            ConnectorResponse response = request.execute();
            this.applyOutputParameters(execution, response);
        }
        catch (BpmnError bpmne) {
            this.propagateBpmnError(bpmne, execution);
        }
        catch (Exception e) {
            this.propagateExceptionAsError(e, execution);
        }
        this.leave(execution);
    }

    protected void applyInputParameters(ActivityExecution execution, ConnectorRequest<?> request) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorInputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            this.ioMapping.executeInputParameters((AbstractVariableScope)connectorInputVariableScope);
            connectorInputVariableScope.writeToRequest(request);
        }
    }

    protected void applyOutputParameters(ActivityExecution execution, ConnectorResponse response) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorOutputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            connectorOutputVariableScope.readFromResponse(response);
            this.ioMapping.executeOutputParameters((AbstractVariableScope)connectorOutputVariableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConnectorInitialized() {
        if (this.connectorInstance == null) {
            ServiceTaskConnectorActivityBehavior serviceTaskConnectorActivityBehavior = this;
            synchronized (serviceTaskConnectorActivityBehavior) {
                if (this.connectorInstance == null) {
                    this.connectorInstance = Connectors.getConnector((String)this.connectorId);
                    if (this.connectorInstance == null) {
                        throw new ConnectorException("No connector found for connector id '" + this.connectorId + "'");
                    }
                }
            }
        }
    }
}

