/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.plugin.impl;

import org.camunda.bpm.engine.BpmnParseException;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseUtil;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.connect.plugin.impl.ServiceTaskConnectorActivityBehavior;

public class ConnectorParseListener
extends AbstractBpmnParseListener {
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(serviceTaskElement, scope, activity);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        Element messageEventDefinitionElement = endEventElement.element("messageEventDefinition");
        if (messageEventDefinitionElement != null) {
            this.parseConnectorElement(messageEventDefinitionElement, scope, activity);
        }
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        Element messageEventDefinitionElement = intermediateEventElement.element("messageEventDefinition");
        if (messageEventDefinitionElement != null) {
            this.parseConnectorElement(messageEventDefinitionElement, scope, activity);
        }
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(businessRuleTaskElement, scope, activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(sendTaskElement, scope, activity);
    }

    protected void parseConnectorElement(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        Element connectorDefinition = BpmnParseUtil.findCamundaExtensionElement((Element)serviceTaskElement, (String)"connector");
        if (connectorDefinition != null) {
            Element connectorIdElement = connectorDefinition.element("connectorId");
            String connectorId = null;
            if (connectorIdElement != null) {
                connectorId = connectorIdElement.getText().trim();
            }
            if (connectorIdElement == null || connectorId.isEmpty()) {
                throw new BpmnParseException("No 'id' defined for connector.", connectorDefinition);
            }
            IoMapping ioMapping = BpmnParseUtil.parseInputOutput((Element)connectorDefinition);
            activity.setActivityBehavior((ActivityBehavior)new ServiceTaskConnectorActivityBehavior(connectorId, ioMapping));
        }
    }
}

