/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Named;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.annotation.ProcessVariable;
import org.camunda.bpm.engine.cdi.annotation.ProcessVariableLocal;
import org.camunda.bpm.engine.cdi.impl.ProcessVariableLocalMap;
import org.camunda.bpm.engine.cdi.impl.ProcessVariableMap;

public class ProcessVariables {
    private Logger logger = Logger.getLogger(ProcessVariables.class.getName());
    @Inject
    private BusinessProcess businessProcess;
    @Inject
    private ProcessVariableMap processVariableMap;
    @Inject
    private ProcessVariableLocalMap processVariableLocalMap;

    protected String getVariableName(InjectionPoint ip) {
        String variableName = ((ProcessVariable)ip.getAnnotated().getAnnotation(ProcessVariable.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariable
    protected Object getProcessVariable(InjectionPoint ip) {
        String processVariableName = this.getVariableName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariable(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariables() {
        return this.processVariableMap;
    }

    protected String getVariableLocalName(InjectionPoint ip) {
        String variableName = ((ProcessVariableLocal)ip.getAnnotated().getAnnotation(ProcessVariableLocal.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariableLocal
    protected Object getProcessVariableLocal(InjectionPoint ip) {
        String processVariableName = this.getVariableLocalName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting local process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariableLocal(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariablesLocal() {
        return this.processVariableLocalMap;
    }
}

