/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;

public class ExternalTaskAssert
extends AbstractProcessAssert<ExternalTaskAssert, ExternalTask> {
    protected ExternalTaskAssert(ProcessEngine engine, ExternalTask actual) {
        super(engine, actual, ExternalTaskAssert.class);
    }

    protected static ExternalTaskAssert assertThat(ProcessEngine engine, ExternalTask actual) {
        return new ExternalTaskAssert(engine, actual);
    }

    @Override
    protected ExternalTask getCurrent() {
        return (ExternalTask)this.externalTaskQuery().externalTaskId(((ExternalTask)this.actual).getId()).singleResult();
    }

    public ExternalTaskAssert hasTopicName(String topicName) {
        ExternalTask current = (ExternalTask)this.getExistingCurrent();
        Assertions.assertThat((String)topicName).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)current.getTopicName()).overridingErrorMessage("Expecting %s to have topic name '%s', but found it to be '%s'!", new Object[]{this.toString(current), topicName, current.getTopicName()})).isEqualTo((Object)topicName);
        return this;
    }

    public ExternalTaskAssert hasActivityId(String activityId) {
        ExternalTask current = (ExternalTask)this.getExistingCurrent();
        Assertions.assertThat((String)activityId).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)current.getActivityId()).overridingErrorMessage("Expecting %s to have activity id '%s', but found it to have '%s'!", new Object[]{this.toString(current), activityId, current.getActivityId()})).isEqualTo((Object)activityId);
        return this;
    }

    @Override
    protected String toString(ExternalTask task) {
        return task != null ? String.format("%s {id='%s', processInstanceId='%s', topicName='%s'}", ExternalTask.class.getSimpleName(), task.getId(), task.getProcessInstanceId(), task.getTopicName()) : null;
    }
}

