/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractAssertions;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.ExternalTaskAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.JobAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.ProcessDefinitionAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.ProcessInstanceAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.TaskAssert;

public class BpmnAwareTests
extends AbstractAssertions {
    public static final long DEFAULT_LOCK_DURATION_EXTERNAL_TASK = 30000L;
    public static final String DEFAULT_WORKER_EXTERNAL_TASK = "anonymousWorker";

    protected BpmnAwareTests() {
    }

    public static ProcessDefinitionAssert assertThat(ProcessDefinition actual) {
        return ProcessDefinitionAssert.assertThat(BpmnAwareTests.processEngine(), actual);
    }

    public static ProcessInstanceAssert assertThat(ProcessInstance actual) {
        return ProcessInstanceAssert.assertThat(BpmnAwareTests.processEngine(), actual);
    }

    public static TaskAssert assertThat(Task actual) {
        return TaskAssert.assertThat(BpmnAwareTests.processEngine(), actual);
    }

    public static ExternalTaskAssert assertThat(ExternalTask actual) {
        return ExternalTaskAssert.assertThat(BpmnAwareTests.processEngine(), actual);
    }

    public static JobAssert assertThat(Job actual) {
        return JobAssert.assertThat(BpmnAwareTests.processEngine(), actual);
    }

    public static RuntimeService runtimeService() {
        return BpmnAwareTests.processEngine().getRuntimeService();
    }

    public static AuthorizationService authorizationService() {
        return BpmnAwareTests.processEngine().getAuthorizationService();
    }

    public static FormService formService() {
        return BpmnAwareTests.processEngine().getFormService();
    }

    public static HistoryService historyService() {
        return BpmnAwareTests.processEngine().getHistoryService();
    }

    public static IdentityService identityService() {
        return BpmnAwareTests.processEngine().getIdentityService();
    }

    public static ManagementService managementService() {
        return BpmnAwareTests.processEngine().getManagementService();
    }

    public static RepositoryService repositoryService() {
        return BpmnAwareTests.processEngine().getRepositoryService();
    }

    public static TaskService taskService() {
        return BpmnAwareTests.processEngine().getTaskService();
    }

    public static ExternalTaskService externalTaskService() {
        return BpmnAwareTests.processEngine().getExternalTaskService();
    }

    public static TaskQuery taskQuery() {
        return BpmnAwareTests.taskService().createTaskQuery();
    }

    public static ExternalTaskQuery externalTaskQuery() {
        return BpmnAwareTests.externalTaskService().createExternalTaskQuery();
    }

    public static JobQuery jobQuery() {
        return BpmnAwareTests.managementService().createJobQuery();
    }

    public static ProcessInstanceQuery processInstanceQuery() {
        return BpmnAwareTests.runtimeService().createProcessInstanceQuery();
    }

    public static ProcessDefinitionQuery processDefinitionQuery() {
        return BpmnAwareTests.repositoryService().createProcessDefinitionQuery();
    }

    public static ExecutionQuery executionQuery() {
        return BpmnAwareTests.runtimeService().createExecutionQuery();
    }

    public static Map<String, Object> withVariables(String key, Object value, Object ... furtherKeyValuePairs) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Illegal call of withVariables(key = '%s', value = '%s', ...) - key must not be null!", key, value));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        if (furtherKeyValuePairs != null) {
            if (furtherKeyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Illegal call of withVariables() - must have an even number of arguments, but found length = %s!", furtherKeyValuePairs.length + 2));
            }
            for (int i = 0; i < furtherKeyValuePairs.length; i += 2) {
                if (!(furtherKeyValuePairs[i] instanceof String)) {
                    throw new IllegalArgumentException(String.format("Illegal call of withVariables() - keys must be strings, found object of type '%s'!", furtherKeyValuePairs[i] != null ? furtherKeyValuePairs[i].getClass().getName() : null));
                }
                map.put((String)furtherKeyValuePairs[i], furtherKeyValuePairs[i + 1]);
            }
        }
        return map;
    }

    public static Task task() {
        return BpmnAwareTests.task(BpmnAwareTests.taskQuery());
    }

    public static Task task(ProcessInstance processInstance) {
        return BpmnAwareTests.task(BpmnAwareTests.taskQuery(), processInstance);
    }

    public static Task task(String taskDefinitionKey) {
        Assertions.assertThat((String)taskDefinitionKey).isNotNull();
        return BpmnAwareTests.task(BpmnAwareTests.taskQuery().taskDefinitionKey(taskDefinitionKey));
    }

    public static Task task(String taskDefinitionKey, ProcessInstance processInstance) {
        Assertions.assertThat((String)taskDefinitionKey).isNotNull();
        return BpmnAwareTests.task(BpmnAwareTests.taskQuery().taskDefinitionKey(taskDefinitionKey), processInstance);
    }

    public static Task task(TaskQuery taskQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.task(taskQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static Task task(TaskQuery taskQuery, ProcessInstance processInstance) {
        return (Task)((ProcessInstanceAssert)BpmnAwareTests.assertThat(processInstance).isNotNull()).task(taskQuery).getActual();
    }

    public static ExternalTask externalTask() {
        return BpmnAwareTests.externalTask(BpmnAwareTests.externalTaskQuery());
    }

    public static ExternalTask externalTask(ProcessInstance processInstance) {
        return BpmnAwareTests.externalTask(BpmnAwareTests.externalTaskQuery(), processInstance);
    }

    public static ExternalTask externalTask(String activityId) {
        Assertions.assertThat((String)activityId).isNotNull();
        return BpmnAwareTests.externalTask(BpmnAwareTests.externalTaskQuery().activityId(activityId));
    }

    public static ExternalTask externalTask(String activityId, ProcessInstance processInstance) {
        Assertions.assertThat((String)activityId).isNotNull();
        return BpmnAwareTests.externalTask(BpmnAwareTests.externalTaskQuery().activityId(activityId), processInstance);
    }

    public static ExternalTask externalTask(ExternalTaskQuery externalTaskQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.externalTask(externalTaskQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static ExternalTask externalTask(ExternalTaskQuery externalTaskQuery, ProcessInstance processInstance) {
        return (ExternalTask)((ProcessInstanceAssert)BpmnAwareTests.assertThat(processInstance).isNotNull()).externalTask(externalTaskQuery).getActual();
    }

    public static ProcessDefinition processDefinition() {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.processDefinition((ProcessInstance)lastAssert.getActual());
    }

    public static ProcessDefinition processDefinition(ProcessInstance processInstance) {
        BpmnAwareTests.assertThat(processInstance).isNotNull();
        return BpmnAwareTests.processDefinition(BpmnAwareTests.processDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()));
    }

    public static ProcessDefinition processDefinition(String processDefinitionKey) {
        Assertions.assertThat((String)processDefinitionKey).isNotNull();
        return BpmnAwareTests.processDefinition(BpmnAwareTests.processDefinitionQuery().processDefinitionKey(processDefinitionKey));
    }

    public static ProcessDefinition processDefinition(ProcessDefinitionQuery processDefinitionQuery) {
        return (ProcessDefinition)processDefinitionQuery.singleResult();
    }

    public static ProcessInstance calledProcessInstance() {
        return BpmnAwareTests.calledProcessInstance(BpmnAwareTests.processInstanceQuery());
    }

    public static ProcessInstance calledProcessInstance(ProcessInstance processInstance) {
        return BpmnAwareTests.calledProcessInstance(BpmnAwareTests.processInstanceQuery(), processInstance);
    }

    public static ProcessInstance calledProcessInstance(String processDefinitionKey) {
        Assertions.assertThat((String)processDefinitionKey).isNotNull();
        return BpmnAwareTests.calledProcessInstance(BpmnAwareTests.processInstanceQuery().processDefinitionKey(processDefinitionKey));
    }

    public static ProcessInstance calledProcessInstance(String processDefinitionKey, ProcessInstance processInstance) {
        Assertions.assertThat((String)processDefinitionKey).isNotNull();
        return BpmnAwareTests.calledProcessInstance(BpmnAwareTests.processInstanceQuery().processDefinitionKey(processDefinitionKey), processInstance);
    }

    public static ProcessInstance calledProcessInstance(ProcessInstanceQuery processInstanceQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.calledProcessInstance(processInstanceQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static ProcessInstance calledProcessInstance(ProcessInstanceQuery processInstanceQuery, ProcessInstance processInstance) {
        return (ProcessInstance)((ProcessInstanceAssert)BpmnAwareTests.assertThat(processInstance).isNotNull()).calledProcessInstance(processInstanceQuery).getActual();
    }

    public static Job job() {
        return BpmnAwareTests.job(BpmnAwareTests.jobQuery());
    }

    public static Job job(ProcessInstance processInstance) {
        return BpmnAwareTests.job(BpmnAwareTests.jobQuery(), processInstance);
    }

    public static Job job(String activityId) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.job(activityId, (ProcessInstance)lastAssert.getActual());
    }

    public static Job job(String activityId, ProcessInstance processInstance) {
        return (Job)((ProcessInstanceAssert)BpmnAwareTests.assertThat(processInstance).isNotNull()).job(activityId).getActual();
    }

    public static Job job(JobQuery jobQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return BpmnAwareTests.job(jobQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static Job job(JobQuery jobQuery, ProcessInstance processInstance) {
        return (Job)((ProcessInstanceAssert)BpmnAwareTests.assertThat(processInstance).isNotNull()).job(jobQuery).getActual();
    }

    public static Task claim(Task task, String assigneeUserId) {
        if (task == null || assigneeUserId == null) {
            throw new IllegalArgumentException(String.format("Illegal call of claim(task = '%s', assigneeUserId = '%s') - both must not be null!", task, assigneeUserId));
        }
        BpmnAwareTests.taskService().claim(task.getId(), assigneeUserId);
        return (Task)BpmnAwareTests.taskQuery().taskId(task.getId()).singleResult();
    }

    public static Task unclaim(Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Illegal call of unclaim(task = '%s') - task must not be null!", task));
        }
        BpmnAwareTests.taskService().claim(task.getId(), null);
        return (Task)BpmnAwareTests.taskQuery().taskId(task.getId()).singleResult();
    }

    public static void complete(Task task, Map<String, Object> variables) {
        if (task == null || variables == null) {
            throw new IllegalArgumentException(String.format("Illegal call of complete(task = '%s', variables = '%s') - both must not be null!", task, variables));
        }
        BpmnAwareTests.taskService().complete(task.getId(), variables);
    }

    public static void complete(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Illegal call of complete(task = 'null') - must not be null!");
        }
        BpmnAwareTests.taskService().complete(task.getId());
    }

    public static void complete(ExternalTask externalTask) {
        if (externalTask == null) {
            throw new IllegalArgumentException("Illegal call of completeExternalTask(externalTask = 'null') - must not be null!");
        }
        BpmnAwareTests.complete(externalTask, Collections.emptyMap());
    }

    public static void complete(ExternalTask externalTask, Map<String, Object> variables) {
        if (externalTask == null || variables == null) {
            throw new IllegalArgumentException(String.format("Illegal call of completeExternalTask(externalTask = '%s', variables = '%s') - both must not be null!", externalTask, variables));
        }
        List<LockedExternalTask> lockedTasks = BpmnAwareTests.fetchAndLock(externalTask.getTopicName(), DEFAULT_WORKER_EXTERNAL_TASK, 1);
        if (lockedTasks.isEmpty()) {
            throw new NotFoundException(String.format("No lockable external task found for externalTask = '%s', variables = '%s'", externalTask, variables));
        }
        if (!lockedTasks.get(0).getId().equals(externalTask.getId())) {
            throw new IllegalStateException(String.format("Multiple external tasks found for externalTask = '%s', variables = '%s'", externalTask, variables));
        }
        BpmnAwareTests.complete(lockedTasks.get(0), variables);
    }

    public static List<LockedExternalTask> fetchAndLock(String topic, String workerId, int maxResults) {
        if (workerId == null || topic == null) {
            throw new IllegalArgumentException(String.format("Illegal call of fetchAndLock(topic = '%s', workerId = '%s', maxResults = '%s') - all must not be null!", workerId, topic, maxResults));
        }
        return BpmnAwareTests.externalTaskService().fetchAndLock(maxResults, workerId).topic(topic, 30000L).execute();
    }

    public static void complete(LockedExternalTask lockedExternalTask) {
        if (lockedExternalTask == null) {
            throw new IllegalArgumentException("Illegal call of completeExternalTask(lockedExternalTask = 'null') - must not be null!");
        }
        BpmnAwareTests.complete(lockedExternalTask, Collections.emptyMap());
    }

    public static void complete(LockedExternalTask lockedExternalTask, Map<String, Object> variables) {
        if (lockedExternalTask == null || variables == null) {
            throw new IllegalArgumentException(String.format("Illegal call of completeExternalTask(lockedExternalTask = '%s', variables = '%s') - both must not be null!", lockedExternalTask, variables));
        }
        BpmnAwareTests.externalTaskService().complete(lockedExternalTask.getId(), lockedExternalTask.getWorkerId(), variables);
    }

    public static void execute(Job job) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Illegal call of execute(job = '%s') - must not be null!", job));
        }
        Job current = (Job)BpmnAwareTests.jobQuery().jobId(job.getId()).singleResult();
        if (current == null) {
            throw new IllegalStateException(String.format("Illegal state when calling execute(job = '%s') - job does not exist anymore!", job));
        }
        BpmnAwareTests.managementService().executeJob(job.getId());
    }
}

