/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.caffinitas.ohc.benchmark.MergeableTimer;

public final class MergeableTimerSource {
    private final Clock clock = Clock.defaultClock();
    private final AtomicLong count = new AtomicLong();
    private final AtomicReference<Histogram> histogram = new AtomicReference<Histogram>(new Histogram((Reservoir)new UniformReservoir()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public void mergeTo(MergeableTimer timer) {
        Histogram hist = this.histogram.getAndSet(new Histogram((Reservoir)new UniformReservoir()));
        for (long l : hist.getSnapshot().getValues()) {
            timer.histogram.update(l);
        }
        timer.meter.mark(this.count.getAndSet(0L));
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.get().update(duration);
            this.count.incrementAndGet();
        }
    }

    public void clear() {
        this.histogram.set(new Histogram((Reservoir)new UniformReservoir()));
        this.count.set(0L);
    }
}

