/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.at.impl;

import java.util.Objects;
import java.util.Optional;
import org.cadixdev.at.AccessTransform;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;

final class AccessTransformSetMapper {
    private AccessTransformSetMapper() {
    }

    static AccessTransformSet remap(AccessTransformSet set, MappingSet mappings) {
        Objects.requireNonNull(set, "set");
        Objects.requireNonNull(mappings, "mappings");
        AccessTransformSet remapped = AccessTransformSet.create();
        set.getClasses().forEach((className, classSet) -> {
            Optional mapping = mappings.getClassMapping(className);
            AccessTransformSetMapper.remap(mapping, classSet, remapped.getOrCreateClass(mapping.map(Mapping::getFullDeobfuscatedName).orElse((String)className)));
        });
        return remapped;
    }

    private static void remap(Optional<? extends ClassMapping<?, ?>> mapping, AccessTransformSet.Class set, AccessTransformSet.Class remapped) {
        remapped.merge(set.get());
        remapped.mergeAllFields(set.allFields());
        remapped.mergeAllMethods(set.allMethods());
        set.getFields().forEach((name, transform) -> remapped.mergeField(mapping.flatMap(m -> m.getFieldMapping(name)).map(Mapping::getDeobfuscatedName).orElse((String)name), (AccessTransform)transform));
        set.getMethods().forEach((signature, transform) -> remapped.mergeMethod(mapping.flatMap(m -> m.getMethodMapping(signature)).map(MethodMapping::getDeobfuscatedSignature).orElse((MethodSignature)signature), (AccessTransform)transform));
    }
}

