/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanPropertyMutator {
    private static final String SETTER_PREFIX = "set";
    private final Map<String, Method> settersLookupMap;

    public BeanPropertyMutator(Class<?> clazz) {
        this.settersLookupMap = BeanPropertyMutator.generateSetterLookupMap(clazz);
    }

    public Class<?> getType(String propertyName) {
        Method m = this.settersLookupMap.get(propertyName);
        if (m == null) {
            return null;
        }
        return m.getParameterTypes()[0];
    }

    public void mutate(Object target, String propertyName, Object value) throws IllegalAccessException, InvocationTargetException {
        Method m = this.settersLookupMap.get(propertyName);
        m.invoke(target, value);
    }

    private static boolean preferCacheTypeAndNotClass(Class<?> c) {
        return !Class.class.equals(c);
    }

    static Map<String, Method> generateSetterLookupMap(Class<?> c) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method m : c.getMethods()) {
            String propertyName;
            Method m0;
            if (!m.getName().startsWith(SETTER_PREFIX) || m.getReturnType() != Void.TYPE || m.getParameterTypes().length != 1 || !BeanPropertyMutator.preferCacheTypeAndNotClass(m.getParameterTypes()[0]) || (m0 = map.put(propertyName = BeanPropertyMutator.generatePropertyNameFromSetter(m.getName()), m)) == null) continue;
            throw new IllegalArgumentException("Ambiguous setter for property '" + propertyName + "' in class '" + c.getSimpleName() + "'");
        }
        return map;
    }

    static String generatePropertyNameFromSetter(String s) {
        return BeanPropertyMutator.changeFirstCharToLowerCase(s.substring(SETTER_PREFIX.length()));
    }

    static String changeFirstCharToLowerCase(String v) {
        return Character.toLowerCase(v.charAt(0)) + v.substring(1);
    }
}

