/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cache2k.core.timing.DefaultScheduler;
import org.cache2k.core.timing.Scheduler;
import org.cache2k.core.timing.Timer;
import org.cache2k.core.timing.TimerStructure;
import org.cache2k.core.timing.TimerTask;
import org.cache2k.core.timing.TimerWheels;
import org.cache2k.core.util.InternalClock;

public class DefaultTimer
implements Timer {
    private final Lock lock = new ReentrantLock();
    private final InternalClock clock;
    private final Scheduler scheduler;
    private final TimerStructure structure;
    private long nextScheduled = Long.MAX_VALUE;
    private long lagMillis;
    private final Runnable timerAction = new Runnable(){

        @Override
        public void run() {
            DefaultTimer.this.timeReachedEvent(DefaultTimer.this.clock.millis());
        }
    };

    public DefaultTimer(InternalClock c, long lagMillis) {
        this(c, lagMillis, 876);
    }

    public DefaultTimer(InternalClock c, long lagMillis, int steps) {
        this.structure = new TimerWheels(c.millis() + 1L, lagMillis + 1L, steps);
        this.lagMillis = lagMillis;
        this.clock = c;
        this.scheduler = c instanceof Scheduler ? (Scheduler)((Object)this.clock) : DefaultScheduler.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(TimerTask task, long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (!task.isUnscheduled()) {
            throw new IllegalStateException("scheduled already");
        }
        if (time == 0L) {
            this.executeImmediately(task);
            return;
        }
        this.lock.lock();
        try {
            if (this.structure.schedule(task, time)) {
                this.rescheduleEventually(time + this.lagMillis);
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.executeImmediately(task);
    }

    private void executeImmediately(TimerTask task) {
        task.time = 0L;
        task.execute();
        this.scheduler.execute(task);
    }

    @Override
    public void cancel(TimerTask t) {
        this.lock.lock();
        try {
            this.structure.cancel(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getLagMillis() {
        return this.lagMillis;
    }

    @Override
    public void cancelAll() {
        this.lock.lock();
        try {
            this.structure.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeReachedEvent(long currentTime) {
        while (true) {
            TimerTask task;
            this.lock.lock();
            try {
                task = this.structure.removeNextToRun(currentTime);
            }
            finally {
                this.lock.unlock();
            }
            if (task == null) break;
            task.execute();
            task.action();
        }
        this.lock.lock();
        try {
            long nextTime = this.structure.nextRun();
            this.schedule(currentTime, nextTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void schedule(long now, long time) {
        if (time != Long.MAX_VALUE) {
            long earliestTime = now + this.lagMillis;
            this.nextScheduled = Math.max(earliestTime, time);
            this.scheduler.schedule(this.timerAction, this.nextScheduled);
        } else {
            this.nextScheduled = Long.MAX_VALUE;
        }
    }

    void rescheduleEventually(long time) {
        if (time >= this.nextScheduled - this.lagMillis) {
            return;
        }
        this.nextScheduled = time;
        this.scheduler.schedule(this.timerAction, this.nextScheduled);
    }
}

