/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.LoadedEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Progress;
import org.cache2k.processor.MutableCacheEntry;

class MutableEntryOnProgress<K, V>
implements MutableCacheEntry<K, V> {
    private final K key;
    private final ExaminationEntry<K, V> entry;
    private final Progress<K, V, ?> progress;
    private boolean originalExists = false;
    private boolean mutate = false;
    private boolean remove = false;
    private boolean exists = false;
    private V value = null;
    private boolean customExpiry = false;
    private long expiryTime;
    private long refreshTime = this.expiryTime = -1L;

    MutableEntryOnProgress(K key, Progress<K, V, ?> progress, ExaminationEntry<K, V> entry) {
        this.entry = entry;
        this.progress = progress;
        this.key = key;
        if (entry != null && progress.isDataFreshOrMiss()) {
            this.value = this.entry.getValueOrException();
            this.exists = true;
            this.originalExists = true;
        }
    }

    @Override
    public long getCurrentTime() {
        return this.progress.getMutationStartTime();
    }

    @Override
    public long getStartTime() {
        return this.progress.getMutationStartTime();
    }

    @Override
    public boolean exists() {
        this.triggerInstallationRead(false);
        return this.exists;
    }

    @Override
    public MutableCacheEntry<K, V> setValue(V v) {
        this.mutate = true;
        this.exists = true;
        this.remove = false;
        this.value = v;
        return this;
    }

    @Override
    public MutableCacheEntry<K, V> setException(Throwable ex) {
        this.mutate = true;
        this.exists = true;
        this.remove = false;
        this.value = new ExceptionWrapper<K>(this.key, this.progress.getMutationStartTime(), ex, this.progress.getExceptionPropagator());
        return this;
    }

    @Override
    public MutableCacheEntry<K, V> setExpiryTime(long t) {
        this.customExpiry = true;
        this.expiryTime = t;
        return this;
    }

    @Override
    public MutableCacheEntry<K, V> remove() {
        if (this.mutate) {
            this.triggerInstallationRead(true);
        }
        if (this.mutate && !this.originalExists) {
            this.mutate = false;
        } else {
            this.remove = true;
            this.mutate = true;
        }
        this.exists = false;
        this.value = null;
        return this;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        this.triggerLoadOrInstallationRead(false);
        this.checkAndThrowException(this.value);
        return this.value;
    }

    @Override
    public MutableCacheEntry<K, V> reload() {
        if (!this.progress.isLoaderPresent()) {
            throw new UnsupportedOperationException("Loader is not configured");
        }
        if (!this.progress.wasLoaded()) {
            this.triggerLoadOrInstallationRead(false);
            throw new Operations.NeedsLoadRestartException();
        }
        return this;
    }

    private void triggerLoadOrInstallationRead(boolean ignoreMutate) {
        this.triggerInstallationRead(ignoreMutate);
        if (!this.exists && (ignoreMutate || !this.mutate) && this.progress.isLoaderPresent()) {
            throw new Operations.NeedsLoadRestartException();
        }
    }

    private void triggerInstallationRead(boolean ignoreMutate) {
        if ((ignoreMutate || !this.mutate) && this.entry == null) {
            throw new Operations.WantsDataRestartException();
        }
    }

    @Override
    public V getOldValue() {
        this.triggerLoadOrInstallationRead(true);
        if (!this.originalExists || this.entry instanceof LoadedEntry) {
            return null;
        }
        V value = this.entry.getValueOrException();
        this.checkAndThrowException(value);
        return value;
    }

    private void checkAndThrowException(V value) {
        if (value instanceof ExceptionWrapper) {
            ((ExceptionWrapper)value).propagateException();
        }
    }

    @Override
    public boolean wasExisting() {
        this.triggerInstallationRead(true);
        this.checkAndThrowException(this.value);
        return this.originalExists && !(this.entry instanceof LoadedEntry);
    }

    @Override
    public Throwable getException() {
        this.triggerLoadOrInstallationRead(false);
        if (this.value instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.value).getException();
        }
        return null;
    }

    @Override
    public long getRefreshedTime() {
        this.triggerInstallationRead(false);
        if (this.refreshTime != -1L) {
            return this.refreshTime;
        }
        return this.originalExists ? this.entry.getRefreshTime() : 0L;
    }

    @Override
    public MutableCacheEntry<K, V> setRefreshedTime(long t) {
        this.refreshTime = t;
        return this;
    }

    @Override
    public long getLastModification() {
        throw new UnsupportedOperationException();
    }

    public boolean isMutationNeeded() {
        return this.mutate || this.customExpiry;
    }

    public void sendMutationCommand() {
        if (this.mutate) {
            if (this.remove) {
                this.progress.remove();
                return;
            }
            if (this.customExpiry || this.refreshTime != -1L) {
                this.progress.putAndSetExpiry(this.value, this.expiryTime, this.refreshTime);
                return;
            }
            this.progress.put(this.value);
            return;
        }
        this.progress.expire(this.expiryTime);
    }
}

