/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.concurrency;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.cache2k.core.concurrency.OptimisticLock;

public class NonOptimisticLock
implements OptimisticLock {
    private static final int DUMMY = 4711;
    private final Sync sync = new Sync();

    @Override
    public long readLock() {
        this.sync.acquire(4711);
        return 4711L;
    }

    @Override
    public long writeLock() {
        this.sync.acquire(4711);
        return 4711L;
    }

    @Override
    public long tryOptimisticRead() {
        return this.sync.getStamp() == 1 ? 0L : 1L;
    }

    @Override
    public boolean validate(long stamp) {
        return false;
    }

    @Override
    public void unlockRead(long stamp) {
        this.sync.release(4711);
    }

    @Override
    public void unlockWrite(long stamp) {
        this.sync.release(4711);
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int UNLOCKED = 0;
        private static final int LOCKED = 1;

        private Sync() {
        }

        @Override
        protected boolean tryAcquire(int acquires) {
            int state = this.getState();
            if (state == 0 && this.compareAndSetState(state, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int releases) {
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        public boolean isHeldExclusively() {
            return this.getState() == 1 && this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        private int getStamp() {
            return this.getState();
        }
    }
}

