/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.concurrency;

import org.cache2k.core.concurrency.NonOptimisticLock;
import org.cache2k.core.concurrency.OptimisticLock;
import org.cache2k.core.concurrency.OptimisticLockStamped;

public class Locks {
    private static final boolean USE_OPTIMISTIC_LOCK = Locks.initializeOptimisticLock();

    public static OptimisticLock newOptimistic() {
        if (USE_OPTIMISTIC_LOCK) {
            return new OptimisticLockStamped();
        }
        return new NonOptimisticLock();
    }

    private static boolean initializeOptimisticLock() {
        try {
            if (System.getProperty(NonOptimisticLock.class.getName()) == null) {
                new OptimisticLockStamped();
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }
}

