/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.ArrayList;
import java.util.List;

public class IntegrityState {
    List<String> failingTests = new ArrayList<String>();
    long state = 0L;
    long bitNr = 0L;
    int stringsHashCode = 0;
    String groupPrefix = "";

    IntegrityState check(boolean f) {
        this.check(null, f);
        return this;
    }

    protected IntegrityState check(String check, String note, boolean f) {
        if (check == null || check.length() == 0) {
            check = "test#" + this.bitNr;
        }
        this.stringsHashCode = this.stringsHashCode * 31 + check.hashCode();
        if (!f) {
            if (note != null) {
                this.failingTests.add(this.groupPrefix + '\"' + check + "\" => " + note);
            } else {
                this.failingTests.add(this.groupPrefix + '\"' + check + '\"');
            }
            this.state |= (long)(1 << (int)this.bitNr);
        }
        ++this.bitNr;
        return this;
    }

    public IntegrityState group(String group) {
        this.groupPrefix = group + ": ";
        return this;
    }

    public IntegrityState check(String check, boolean f) {
        this.check(check, null, f);
        return this;
    }

    public IntegrityState checkEquals(String check, int v1, int v2) {
        if (v1 == v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "==" + v2, false);
        }
        return this;
    }

    public IntegrityState checkEquals(String check, long v1, long v2) {
        if (v1 == v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "==" + v2, false);
        }
        return this;
    }

    public IntegrityState checkLessOrEquals(String check, int v1, int v2) {
        if (v1 <= v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "<=" + v2, false);
        }
        return this;
    }

    public IntegrityState checkLess(String check, int v1, int v2) {
        if (v1 < v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + "<" + v2, false);
        }
        return this;
    }

    public IntegrityState checkGreaterOrEquals(String check, int v1, int v2) {
        if (v1 >= v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + ">=" + v2, false);
        }
        return this;
    }

    public IntegrityState checkGreater(String check, int v1, int v2) {
        if (v1 > v2) {
            this.check(check, null, true);
        } else {
            this.check(check, v1 + ">" + v2, false);
        }
        return this;
    }

    public String getStateDescriptor() {
        return Long.toHexString(this.state) + '.' + this.bitNr + '.' + Integer.toHexString(this.stringsHashCode);
    }

    public long getStateFlags() {
        return this.state;
    }

    public String getFailingChecks() {
        return this.failingTests.toString();
    }

    public void throwIfNeeded() {
        if (this.state > 0L) {
            throw new IllegalStateException("Integrity test failed: " + this.failingTests.toString());
        }
    }
}

