/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Date;
import java.util.Iterator;
import org.cache2k.core.HealthInfoElement;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.jmx.CacheMXBean;

public class CacheMXBeanImpl
implements CacheMXBean {
    private final InternalCache cache;

    @Override
    public String getKeyType() {
        return this.cache.getKeyType().getTypeName();
    }

    @Override
    public String getValueType() {
        return this.cache.getValueType().getTypeName();
    }

    public CacheMXBeanImpl(InternalCache cache) {
        this.cache = cache;
    }

    private InternalCacheInfo getInfo() {
        return this.cache.getInfo();
    }

    @Override
    public long getSize() {
        return this.getInfo().getSize();
    }

    @Override
    public long getEntryCapacity() {
        return this.getInfo().getHeapCapacity();
    }

    @Override
    public long getCapacityLimit() {
        return this.isWeigherPresent() ? this.getTotalWeight() : this.getEntryCapacity();
    }

    @Override
    public long getMaximumWeight() {
        return this.getInfo().getMaximumWeight();
    }

    @Override
    public long getTotalWeight() {
        return this.getInfo().getTotalWeight();
    }

    @Override
    public long getMissCount() {
        return this.getInfo().getMissCount();
    }

    @Override
    public long getInsertCount() {
        return this.getInfo().getNewEntryCount();
    }

    @Override
    public long getLoadCount() {
        return this.getInfo().getLoadCount();
    }

    @Override
    public long getRefreshCount() {
        return this.getInfo().getRefreshCount();
    }

    @Override
    public long getRefreshFailedCount() {
        return this.getInfo().getRefreshRejectedCount();
    }

    @Override
    public long getRefreshedHitCount() {
        return this.getInfo().getRefreshedHitCount();
    }

    @Override
    public long getExpiredCount() {
        return this.getInfo().getExpiredCount();
    }

    @Override
    public long getEvictedCount() {
        return this.getInfo().getEvictedCount();
    }

    @Override
    public long getEvictedWeight() {
        return this.getInfo().getEvictedWeight();
    }

    @Override
    public long getKeyMutationCount() {
        return this.getInfo().getKeyMutationCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.getInfo().getLoadExceptionCount();
    }

    @Override
    public long getSuppressedLoadExceptionCount() {
        return this.getInfo().getSuppressedExceptionCount();
    }

    @Override
    public long getGetCount() {
        return this.getInfo().getGetCount();
    }

    @Override
    public long getPutCount() {
        return this.getInfo().getPutCount();
    }

    @Override
    public long getClearCount() {
        return this.getInfo().getClearCount();
    }

    @Override
    public long getRemoveCount() {
        return this.getInfo().getRemoveCount();
    }

    @Override
    public long getClearedEntriesCount() {
        return this.getInfo().getClearedEntriesCount();
    }

    @Override
    public double getHitRate() {
        return this.getInfo().getHitRate();
    }

    @Override
    public int getHashQuality() {
        return -1;
    }

    @Override
    public double getMillisPerLoad() {
        return this.getInfo().getMillisPerLoad();
    }

    @Override
    public long getTotalLoadMillis() {
        return this.getInfo().getLoadMillis();
    }

    @Override
    public String getIntegrityDescriptor() {
        return this.getInfo().getIntegrityDescriptor();
    }

    @Override
    public Date getCreatedTime() {
        return new Date(this.getInfo().getStartedTime());
    }

    @Override
    public Date getClearedTime() {
        return this.optionalDate(this.getInfo().getClearedTime());
    }

    @Override
    public Date getInfoCreatedTime() {
        return new Date(this.getInfo().getInfoCreatedTime());
    }

    Date optionalDate(long millis) {
        return millis == 0L ? null : new Date(millis);
    }

    @Override
    public int getInfoCreatedDeltaMillis() {
        return this.getInfo().getInfoCreationDeltaMs();
    }

    @Override
    public String getImplementation() {
        return this.getInfo().getImplementation();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void changeCapacity(long entryCountOrWeight) {
        this.cache.getEviction().changeCapacity(entryCountOrWeight);
    }

    @Override
    public int getAlert() {
        Iterator<HealthInfoElement> it = this.getInfo().getHealth().iterator();
        if (!it.hasNext()) {
            return 0;
        }
        HealthInfoElement hi = it.next();
        if ("FAILURE".equals(hi.getLevel())) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getEvictionStatistics() {
        return this.getInfo().getExtraStatistics();
    }

    @Override
    public boolean isLoaderPresent() {
        return this.cache.isLoaderPresent();
    }

    @Override
    public boolean isWeigherPresent() {
        return this.cache.isWeigherPresent();
    }
}

