/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.core.CacheCloseContext;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheMXBeanImpl;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.jmx.CacheInfoMXBean;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class BaseCache<K, V>
implements InternalCache<K, V>,
CacheCloseContext {
    public abstract Executor getExecutor();

    protected abstract <R> EntryAction<K, V, R> createFireAndForgetAction(Entry<K, V> var1, Semantic<K, V, R> var2);

    public static String nameQualifier(Cache<?, ?> cache) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(cache.getName()).append('\'');
        if (!cache.getCacheManager().isDefaultManager()) {
            sb.append(", manager='").append(cache.getCacheManager().getName()).append('\'');
        }
        return sb.toString();
    }

    protected abstract Iterator<CacheEntry<K, V>> iterator();

    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = BaseCache.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<CacheEntry<K, V>> entries() {
        return new Iterable<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return BaseCache.this.iterator();
            }
        };
    }

    @Override
    public void removeAll() {
        this.removeAll(this.keys());
    }

    @Override
    public void removeAll(Iterable<? extends K> keys) {
        for (K k : keys) {
            this.remove(k);
        }
    }

    @Override
    public <X> X requestInterface(Class<X> type) {
        if (type.equals(ConcurrentMap.class) || type.equals(Map.class)) {
            return (X)new ConcurrentMapWrapper(this);
        }
        if (type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        return null;
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    @Override
    public StorageAdapter getStorage() {
        return null;
    }

    @Override
    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap m = new HashMap();
        for (K k : keys) {
            try {
                final R result = this.invoke(k, entryProcessor);
                if (result == null) continue;
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        return result;
                    }

                    @Override
                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (EntryProcessingException t) {
                final Throwable cause = t.getCause();
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        throw new EntryProcessingException(cause);
                    }

                    @Override
                    public Throwable getException() {
                        return cause;
                    }
                });
            }
        }
        return m;
    }

    @Override
    public void expireAt(K key, long millis) {
        this.execute(key, Operations.SINGLETON.expire(key, millis));
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> action = this.createEntryAction(key, e, op);
        return this.execute(action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(EntryAction<K, V, R> action) {
        action.start();
        return this.finishExecution(action);
    }

    protected <R> R finishExecution(EntryAction<K, V, R> action) {
        RuntimeException t = action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public void closeCustomization(Object customization, String customizationName) {
        if (customization instanceof Closeable) {
            try {
                ((Closeable)customization).close();
            }
            catch (Exception e) {
                String message = customizationName + ".close() exception (" + BaseCache.nameQualifier(this) + ")";
                throw new CacheException(message, e);
            }
        }
    }

    @Override
    public void clearAndClose() {
        this.close();
    }

    @Override
    public String toString() {
        try {
            InternalCacheInfo fo = this.getLatestInfo();
            return fo.toString();
        }
        catch (CacheClosedException ex) {
            return "Cache(name=" + BaseCache.nameQualifier(this) + ", closed=true)";
        }
    }

    @Override
    public CacheInfoMXBean getStatistics() {
        return new CacheMXBeanImpl(this);
    }
}

