/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.SingletonConfigurationSection;

public class ConfigurationSectionContainer
extends AbstractCollection<ConfigurationSection>
implements Collection<ConfigurationSection>,
Serializable {
    private final Collection<ConfigurationSection> sections = new ArrayList<ConfigurationSection>();

    @Override
    public boolean add(ConfigurationSection section) {
        if (section instanceof SingletonConfigurationSection && this.getSection(section.getClass()) != null) {
            throw new IllegalArgumentException("Section of same type already inserted: " + section.getClass().getName());
        }
        return this.sections.add(section);
    }

    public <T extends ConfigurationSection> T getSection(Class<T> sectionType) {
        for (ConfigurationSection s : this.sections) {
            if (!sectionType.equals(s.getClass())) continue;
            return (T)s;
        }
        return null;
    }

    @Override
    public Iterator<ConfigurationSection> iterator() {
        return this.sections.iterator();
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.sections.toString();
    }
}

