/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

public abstract class TimerTask
implements Runnable {
    private static final long UNSCHEDULED = -1L;
    long time = -1L;
    TimerTask next;
    TimerTask prev = null;

    void insert(TimerTask t) {
        t.next = this.next;
        t.prev = this;
        this.next.prev = t;
        this.next = t;
    }

    void remove() {
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.prev = null;
        this.next = null;
    }

    void execute() {
        this.prev = this;
    }

    void markForImmediateExecution() {
        this.time = 0L;
        this.next = null;
        this.prev = this;
    }

    boolean isOccupied() {
        return this.next != this;
    }

    protected abstract void action();

    protected boolean cancel() {
        if (this.next != null) {
            this.remove();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.action();
    }

    public boolean isUnscheduled() {
        return this.time == -1L;
    }

    public boolean isExecuted() {
        return this.next == null && this.prev == this;
    }

    public boolean isCancelled() {
        return this.prev == null;
    }

    public boolean isScheduled() {
        return this.time != -1L && !this.isCancelled();
    }

    public String getState() {
        if (this.isUnscheduled()) {
            return "unscheduled";
        }
        if (this.isCancelled()) {
            return "cancelled";
        }
        if (this.isExecuted()) {
            return "executed";
        }
        return "scheduled";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{hash=" + Integer.toString(System.identityHashCode(this), 36) + ", state=" + this.getState() + ", time=" + this.time + '}';
    }

    static class Sentinel
    extends TimerTask {
        Sentinel() {
            this.next = this.prev = this;
        }

        @Override
        protected void action() {
        }
    }
}

