/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.core.EntryAction;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.HeapCache;
import org.cache2k.core.MapValueConverterProxy;
import org.cache2k.io.CacheLoaderException;

public class BulkResultCollector<K, V> {
    private int exceptionCount;
    private Throwable anyException;
    private final Map<K, Object> map = new HashMap<K, Object>();

    public void put(K key, Object value) {
        this.map.put(key, value);
        if (value instanceof ExceptionWrapper) {
            this.anyException = ((ExceptionWrapper)value).getException();
            ++this.exceptionCount;
        }
    }

    public Map<K, V> mapOrThrowIfAllFaulty() {
        if (this.exceptionCount > 0 && this.exceptionCount == this.map.size()) {
            throw this.getAnyLoaderException();
        }
        return new MapValueConverterProxy<K, V, Object>(this.map){

            @Override
            protected V convert(Object v) {
                return HeapCache.returnValue(v);
            }
        };
    }

    public CacheLoaderException getAnyLoaderException() {
        if (this.exceptionCount == 0) {
            return null;
        }
        return BulkResultCollector.createBulkLoaderException(this.exceptionCount, this.map.size(), this.anyException);
    }

    public void throwOnAnyLoaderException() {
        if (this.exceptionCount > 0) {
            throw this.getAnyLoaderException();
        }
    }

    public static CacheLoaderException createBulkLoaderException(int exceptionCount, int operationCount, Throwable example) {
        if (exceptionCount > 1) {
            String txt = exceptionCount + " out of " + operationCount + " requests, one as cause";
            return new CacheLoaderException(txt, example);
        }
        return new CacheLoaderException(example);
    }

    public void putAll(Collection<EntryAction<K, V, V>> actions) {
        for (EntryAction<K, V, V> action : actions) {
            if (!action.isResultAvailable()) continue;
            this.put(action.getKey(), action.getResult());
        }
    }
}

