/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cache2k.core.EntryAction;
import org.cache2k.io.AsyncBulkCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoaderException;

public class AsyncBulkAction<K, V, R>
implements AsyncCacheLoader<K, V>,
AsyncBulkCacheLoader.BulkCallback<K, V>,
EntryAction.CompletedCallback<K, V, R> {
    private final Map<K, EntryAction<K, V, R>> key2action = new HashMap<K, EntryAction<K, V, R>>();
    private final Collection<EntryAction<K, V, R>> toStart = new ArrayList<EntryAction<K, V, R>>();
    private final Set<K> toLoad = new HashSet<K>();
    private final Set<K> completed = new HashSet<K>();
    private AsyncCacheLoader<K, V> loader;
    private Throwable exceptionToPropagate;
    private int exceptionCount = 0;

    public synchronized void start(AsyncCacheLoader<K, V> loader, Set<EntryAction<K, V, R>> actions) {
        this.loader = loader;
        this.toStart.addAll(actions);
        for (EntryAction<K, V, R> action : actions) {
            K key = action.getKey();
            this.key2action.put(key, action);
        }
        this.startRemaining();
    }

    private void startRemaining() {
        if (!this.tryStartAll()) {
            this.startOneWithStalling();
        }
    }

    private boolean tryStartAll() {
        boolean someStarted = false;
        ArrayList<EntryAction<K, V, R>> rejected = new ArrayList<EntryAction<K, V, R>>();
        Iterator<EntryAction<K, V, R>> it = this.toStart.iterator();
        while (it.hasNext()) {
            EntryAction<K, V, R> action = it.next();
            action.setBulkMode(true);
            try {
                it.remove();
                action.start();
                someStarted = true;
            }
            catch (EntryAction.AbortWhenProcessingException ex) {
                rejected.add(action);
            }
        }
        this.toStart.addAll(rejected);
        if (someStarted) {
            this.processPendingIo();
        }
        return someStarted;
    }

    private void startOneWithStalling() {
        block0: {
            Iterator<EntryAction<K, V, R>> iterator = this.toStart.iterator();
            if (!iterator.hasNext()) break block0;
            EntryAction<K, V, R> action = iterator.next();
            action.setBulkMode(false);
            action.start();
            this.toStart.remove(action);
        }
    }

    private void processPendingIo() {
        if (!this.toLoad.isEmpty()) {
            this.startBulkLoad();
        }
    }

    public void load(K key, AsyncCacheLoader.Context<K, V> context, AsyncCacheLoader.Callback<V> callback) throws Exception {
        if (((EntryAction)context).isBulkMode()) {
            this.toLoad.add(key);
        } else {
            this.loader.load(key, context, callback);
        }
    }

    private void checkPresent(Object action) {
        if (action == null) {
            this.wrongCallback();
        }
    }

    private void wrongCallback() {
        throw new IllegalArgumentException("Callback key not part of request or already processed");
    }

    private void startBulkLoad() {
        AsyncCacheLoader<K, V> loader = this.loader;
        if (loader instanceof AsyncBulkCacheLoader) {
            AsyncBulkCacheLoader bulkLoader = (AsyncBulkCacheLoader)loader;
            HashSet<AsyncCacheLoader.Context> contextSet = new HashSet<AsyncCacheLoader.Context>();
            for (K key : this.toLoad) {
                contextSet.add(this.key2action.get(key));
            }
            try {
                bulkLoader.loadAll(this.toLoad, contextSet, (AsyncBulkCacheLoader.BulkCallback)this);
            }
            catch (Throwable ouch) {
                this.onLoadFailure(ouch);
            }
        } else {
            for (K key : this.toLoad) {
                EntryAction<K, V, R> action = this.key2action.get(key);
                try {
                    loader.load(key, action, action);
                }
                catch (Throwable ouch) {
                    action.onLoadFailure(ouch);
                }
            }
            this.toLoad.clear();
        }
    }

    public synchronized void onLoadSuccess(Map<? extends K, ? extends V> data) {
        for (Map.Entry<K, V> entry : data.entrySet()) {
            this.onLoadSuccessInternal(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void onLoadSuccess(K key, V value) {
        this.onLoadSuccessInternal(key, value);
    }

    private void onLoadSuccessInternal(K key, V value) {
        boolean present = this.toLoad.remove(key);
        if (!present) {
            this.wrongCallback();
        }
        EntryAction<K, V, R> action = this.key2action.get(key);
        this.checkPresent(action);
        action.onLoadSuccess(value);
    }

    public synchronized void onLoadFailure(Throwable exception) {
        for (K key : this.toLoad) {
            EntryAction<K, V, R> action = this.key2action.get(key);
            action.onLoadFailure(exception);
        }
        this.toLoad.clear();
    }

    @Override
    public synchronized void entryActionCompleted(EntryAction<K, V, R> ea) {
        this.propagateFirstException(ea);
        this.completed.add(ea.getKey());
        int started = this.key2action.size() - this.toStart.size();
        if (this.completed.size() == started) {
            if (!this.toStart.isEmpty()) {
                this.startRemaining();
            } else {
                this.bulkOperationCompleted();
            }
        }
    }

    private void propagateFirstException(EntryAction<K, V, R> ea) {
        Throwable exception = ea.getException();
        if (exception != null) {
            ++this.exceptionCount;
        }
        if (this.exceptionToPropagate == null && exception != null) {
            this.exceptionToPropagate = exception;
        }
    }

    public Throwable getExceptionToPropagate() {
        if (this.exceptionToPropagate instanceof CacheLoaderException) {
            String txt = "finished with " + this.exceptionCount + " exceptions out of " + this.key2action.size() + " operations, one propagated as cause";
            return new CacheLoaderException(txt, this.exceptionToPropagate.getCause());
        }
        return this.exceptionToPropagate;
    }

    public Collection<EntryAction<K, V, R>> getActions() {
        return this.key2action.values();
    }

    public Map<K, R> getResultMap() {
        HashMap map = new HashMap();
        for (Map.Entry<K, EntryAction<K, V, R>> e : this.key2action.entrySet()) {
            map.put(e.getKey(), e.getValue().result);
        }
        return map;
    }

    protected void bulkOperationCompleted() {
    }
}

