/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.CacheEntry;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.api.InternalCacheCloseContext;
import org.cache2k.core.timing.DefaultSchedulerProvider;
import org.cache2k.core.timing.DefaultTimer;
import org.cache2k.core.timing.Tasks;
import org.cache2k.core.timing.Timer;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.core.timing.Timing;
import org.cache2k.expiry.Expiry;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.io.ResiliencePolicy;
import org.cache2k.operation.Scheduler;
import org.cache2k.operation.TimeReference;

public class StaticTiming<K, V>
extends Timing<K, V> {
    static final long SAFETY_GAP_MILLIS = HeapCache.TUNABLE.sharpExpirySafetyGapMillis;
    protected final ResiliencePolicy<K, V> resiliencePolicy;
    protected final TimeReference clock;
    protected final boolean sharpExpiry;
    protected final boolean refreshAhead;
    protected final long expiryMillis;
    protected final long lagMillis;
    private final Timer timer;
    private TimerEventListener<K, V> target;

    StaticTiming(InternalCacheBuildContext<K, V> buildContext, ResiliencePolicy<K, V> resiliencePolicy) {
        this.clock = buildContext.getClock();
        Cache2kConfig<K, V> cfg = buildContext.getConfig();
        this.expiryMillis = cfg.getExpireAfterWrite() == null || cfg.getExpireAfterWrite() == Cache2kConfig.EXPIRY_ETERNAL ? Long.MAX_VALUE : cfg.getExpireAfterWrite().toMillis();
        this.refreshAhead = cfg.isRefreshAhead();
        this.sharpExpiry = cfg.isSharpExpiry();
        this.lagMillis = cfg.getTimerLag() == null ? HeapCache.TUNABLE.timerLagMillis : cfg.getTimerLag().toMillis();
        Scheduler scheduler = cfg.getScheduler() != null ? (Scheduler)buildContext.createCustomization(cfg.getScheduler()) : (this.clock instanceof Scheduler ? (Scheduler)this.clock : buildContext.createCustomization(DefaultSchedulerProvider.INSTANCE));
        this.timer = new DefaultTimer(this.clock, scheduler, this.lagMillis);
        this.resiliencePolicy = resiliencePolicy;
    }

    @Override
    public void setTarget(TimerEventListener<K, V> target) {
        this.target = target;
    }

    @Override
    public void cancelAll() {
        this.timer.cancelAll();
    }

    @Override
    public void close(InternalCacheCloseContext closeContext) {
        closeContext.closeCustomization(this.resiliencePolicy, "resiliencePolicy");
        this.timer.close(closeContext);
    }

    @Override
    public long calculateNextRefreshTime(Entry<K, V> e, V v, long loadTime) {
        return StaticTiming.calcNextRefreshTime(e.getKey(), v, loadTime, e, null, this.expiryMillis, this.sharpExpiry);
    }

    @Override
    public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
        long pointInTime = this.resiliencePolicy.suppressExceptionUntil(e.getKey(), inf, e.getInspectionEntry());
        return Expiry.mixTimeSpanAndPointInTime((long)inf.getLoadTime(), (long)this.expiryMillis, (long)pointInTime);
    }

    @Override
    public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInfo inf) {
        long pointInTime = this.resiliencePolicy.retryLoadAfter(e.getKey(), inf);
        return Expiry.mixTimeSpanAndPointInTime((long)inf.getLoadTime(), (long)this.expiryMillis, (long)pointInTime);
    }

    long expiredEventuallyStartBackgroundRefresh(Entry<K, V> e, boolean sharpExpiry) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
            this.scheduleTask(0L, e);
            return sharpExpiry ? 5L : 16L;
        }
        return 4L;
    }

    @Override
    public long stopStartTimer(long expiryTime, Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        if (expiryTime == 0L) {
            return 4L;
        }
        if (expiryTime == -1L) {
            long nrt = e.getNextRefreshTime();
            if (nrt == 0L) {
                throw new IllegalArgumentException("neutral expiry not allowed for creation");
            }
            return e.getNextRefreshTime();
        }
        if (expiryTime == Long.MAX_VALUE) {
            return expiryTime;
        }
        long now = this.clock.millis();
        if (Math.abs(expiryTime) <= now) {
            return this.expiredEventuallyStartBackgroundRefresh(e, expiryTime < 0L);
        }
        if (expiryTime < 0L) {
            long timerTime = -expiryTime - SAFETY_GAP_MILLIS - this.timer.getLagMillis();
            if (timerTime >= now) {
                e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
                this.scheduleTask(timerTime, e);
                expiryTime = -expiryTime;
            } else {
                this.scheduleFinalExpireWithOptionalRefresh(e, -expiryTime);
            }
        } else {
            this.scheduleFinalExpireWithOptionalRefresh(e, expiryTime);
        }
        return expiryTime;
    }

    @Override
    public boolean startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        this.cancelExpiryTimer(e);
        long absTime = Math.abs(nextRefreshTime);
        e.setRefreshProbationNextRefreshTime(absTime);
        e.setNextRefreshTime(6L);
        if (nextRefreshTime != Long.MAX_VALUE) {
            e.setTask(new Tasks.RefreshExpireTimerTask<K, V>().to(this.target, e));
            this.scheduleTask(absTime, e);
        }
        return false;
    }

    @Override
    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        this.scheduleFinalExpireWithOptionalRefresh(e, e.getNextRefreshTime());
    }

    void scheduleFinalExpireWithOptionalRefresh(Entry<K, V> e, long t) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
        } else {
            e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
        }
        this.scheduleTask(t, e);
    }

    void scheduleTask(long nextRefreshTime, Entry<K, V> e) {
        try {
            this.timer.schedule(e.getTask(), nextRefreshTime);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void cancelExpiryTimer(Entry<K, V> e) {
        Tasks tsk = (Tasks)e.getTask();
        if (tsk != null) {
            this.timer.cancel(tsk);
        }
        e.setTask(null);
    }

    static <K, V> long calcNextRefreshTime(K key, V newValue, long now, CacheEntry<K, V> entry, ExpiryPolicy<K, V> policy, long maxLinger, boolean sharpExpiryEnabled) {
        long t;
        if (maxLinger == 0L) {
            return 0L;
        }
        if (policy != null) {
            long t2 = policy.calculateExpiryTime(key, newValue, now, entry);
            return StaticTiming.limitExpiryToMaxLinger(now, maxLinger, t2, sharpExpiryEnabled);
        }
        if (maxLinger < Long.MAX_VALUE && (t = maxLinger + now) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    static long limitExpiryToMaxLinger(long now, long maxLinger, long requestedExpiryTime, boolean sharpExpiryEnabled) {
        if (sharpExpiryEnabled && requestedExpiryTime > 0L && requestedExpiryTime < Long.MAX_VALUE) {
            requestedExpiryTime = -requestedExpiryTime;
        }
        return Expiry.mixTimeSpanAndPointInTime((long)now, (long)maxLinger, (long)requestedExpiryTime);
    }
}

