/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CustomizationException;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.CacheType;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntHeapCache;
import org.cache2k.core.WiredCache;
import org.cache2k.core.api.InternalCacheBuildContext;
import org.cache2k.core.event.AsyncDispatcher;
import org.cache2k.core.event.AsyncEvent;
import org.cache2k.core.eviction.EvictionFactory;
import org.cache2k.core.timing.Timing;
import org.cache2k.core.util.DefaultClock;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheCreatedListener;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.event.CacheLifecycleListener;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.operation.TimeReference;

public class InternalCache2kBuilder<K, V>
implements InternalCacheBuildContext<K, V> {
    private static final AtomicLong DERIVED_NAME_COUNTER = new AtomicLong(System.currentTimeMillis() % 1234L);
    private final CacheManagerImpl manager;
    private final Cache2kConfig<K, V> config;
    private TimeReference clock;
    static final EvictionFactory EVICTION_FACTORY = new EvictionFactory();

    public InternalCache2kBuilder(Cache2kConfig<K, V> config, CacheManager manager) {
        this.config = config;
        this.manager = (CacheManagerImpl)(manager == null ? CacheManager.getInstance() : manager);
    }

    private static boolean isBuilderClass(String className) {
        return Cache2kBuilder.class.getName().equals(className);
    }

    private static String deriveNameFromStackTrace() {
        boolean builderSeen = false;
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (builderSeen && !InternalCache2kBuilder.isBuilderClass(e.getClassName())) {
                String methodName = e.getMethodName();
                if (methodName.equals("<init>")) {
                    methodName = "INIT";
                }
                if (methodName.equals("<clinit>")) {
                    methodName = "CLINIT";
                }
                return "_" + e.getClassName() + "." + methodName + "-" + e.getLineNumber() + "-" + Long.toString(DERIVED_NAME_COUNTER.incrementAndGet(), 36);
            }
            builderSeen = InternalCache2kBuilder.isBuilderClass(e.getClassName());
        }
        throw new IllegalArgumentException("name missing and automatic generation failed");
    }

    public String getName() {
        return this.config.getName();
    }

    @Override
    public TimeReference getClock() {
        return this.clock;
    }

    @Override
    public Cache2kConfig<K, V> getConfig() {
        return this.config;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    @Override
    public <T> T createCustomization(CustomizationSupplier<T> supplier) {
        if (supplier == null) {
            return null;
        }
        try {
            return (T)supplier.supply((CacheBuildContext)this);
        }
        catch (Exception ex) {
            throw new CustomizationException("Initialization of customization failed", (Throwable)ex);
        }
    }

    private void configureViaSettersDirect(HeapCache<K, V> c) {
        Object obj;
        if (this.config.getLoader() != null && (obj = this.createCustomization(this.config.getLoader())) instanceof CacheLoader) {
            final CacheLoader loader = (CacheLoader)obj;
            c.setAdvancedLoader(new AdvancedCacheLoader<K, V>(){

                public V load(K key, long startTime, CacheEntry<K, V> currentEntry) throws Exception {
                    return loader.load(key);
                }
            });
        }
        if (this.config.getAdvancedLoader() != null) {
            AdvancedCacheLoader loader = (AdvancedCacheLoader)this.createCustomization(this.config.getAdvancedLoader());
            WrappedAdvancedCacheLoader<K, V> wrappedLoader = new WrappedAdvancedCacheLoader<K, V>(c, loader);
            c.setAdvancedLoader(wrappedLoader);
        }
        if (this.config.getExceptionPropagator() != null) {
            c.setExceptionPropagator((ExceptionPropagator)this.createCustomization(this.config.getExceptionPropagator()));
        }
        c.setCacheConfig(this);
    }

    public Cache<K, V> build() {
        Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.augmentConfig(this.manager, this.config);
        return this.buildWithoutExternalConfig();
    }

    public Cache<K, V> buildWithoutExternalConfig() {
        if (this.config.getValueType() == null) {
            this.config.setValueType(CacheType.of(Object.class));
        }
        if (this.config.getKeyType() == null) {
            this.config.setKeyType(CacheType.of(Object.class));
        }
        if (this.config.getName() == null) {
            this.config.setName(InternalCache2kBuilder.deriveNameFromStackTrace());
            this.config.setNameWasGenerated(true);
        }
        if (this.config.hasFeatures()) {
            this.config.getFeatures().stream().forEach(x -> x.enlist((CacheBuildContext)this));
        }
        this.checkConfiguration();
        Class keyType = this.config.getKeyType().getType();
        Cache cache = keyType == Integer.class ? new IntHeapCache() : new HeapCache();
        this.clock = this.createCustomization(this.config.getTimeReference(), DefaultClock.INSTANCE);
        HeapCache bc = (HeapCache)cache;
        bc.setCacheManager(this.manager);
        this.configureViaSettersDirect(bc);
        bc.setClock(this.clock);
        if (this.config.isRefreshAhead() && this.config.getAsyncLoader() == null && this.config.getLoader() == null && this.config.getAdvancedLoader() == null) {
            throw new IllegalArgumentException("refresh ahead enabled, but no loader defined");
        }
        boolean wiredCache = this.config.getWeigher() != null || this.config.hasListeners() || this.config.hasAsyncListeners() || this.config.getWriter() != null || this.config.getAsyncLoader() != null;
        WiredCache wc = null;
        if (wiredCache) {
            wc = new WiredCache();
            wc.heapCache = bc;
            cache = wc;
        }
        if (this.config.getTraceCacheWrapper() != null) {
            cache = this.config.getTraceCacheWrapper().wrap((CacheBuildContext)this, cache);
        }
        if (this.config.getCacheWrapper() != null) {
            cache = this.config.getCacheWrapper().wrap((CacheBuildContext)this, cache);
        }
        String name = this.manager.newCache(cache, bc.getName());
        bc.setName(name);
        if (wiredCache) {
            wc.loader = bc.loader;
            wc.writer = (CacheWriter)this.createCustomization(this.config.getWriter());
            wc.asyncLoader = (AsyncCacheLoader)this.createCustomization(this.config.getAsyncLoader());
            ArrayList<CacheEntryCreatedListener> syncCreatedListeners = new ArrayList<CacheEntryCreatedListener>();
            ArrayList<CacheEntryUpdatedListener> syncUpdatedListeners = new ArrayList<CacheEntryUpdatedListener>();
            ArrayList<CacheEntryRemovedListener> syncRemovedListeners = new ArrayList<CacheEntryRemovedListener>();
            ArrayList<CacheEntryExpiredListener> syncExpiredListeners = new ArrayList<CacheEntryExpiredListener>();
            ArrayList<CacheEntryEvictedListener> syncEvictedListeners = new ArrayList<CacheEntryEvictedListener>();
            if (this.config.hasListeners()) {
                for (CustomizationSupplier f : this.config.getListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)this.createCustomization(f);
                    if (el instanceof CacheEntryCreatedListener) {
                        syncCreatedListeners.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        syncUpdatedListeners.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        syncRemovedListeners.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        syncExpiredListeners.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    syncEvictedListeners.add((CacheEntryEvictedListener)el);
                }
            }
            if (this.config.hasAsyncListeners()) {
                Executor asyncExecutor = bc.getExecutor();
                if (this.config.getAsyncListenerExecutor() != null) {
                    asyncExecutor = (Executor)this.createCustomization(this.config.getAsyncListenerExecutor());
                }
                AsyncDispatcher asyncDispatcher = new AsyncDispatcher(wc, asyncExecutor);
                ArrayList<CacheEntryCreatedListener> cll = new ArrayList<CacheEntryCreatedListener>();
                ArrayList<CacheEntryUpdatedListener> ull = new ArrayList<CacheEntryUpdatedListener>();
                ArrayList<CacheEntryRemovedListener> rll = new ArrayList<CacheEntryRemovedListener>();
                ArrayList<CacheEntryExpiredListener> ell = new ArrayList<CacheEntryExpiredListener>();
                ArrayList<CacheEntryEvictedListener> evl = new ArrayList<CacheEntryEvictedListener>();
                for (CustomizationSupplier customizationSupplier : this.config.getAsyncListeners()) {
                    CacheEntryOperationListener el = (CacheEntryOperationListener)this.createCustomization(customizationSupplier);
                    if (el instanceof CacheEntryCreatedListener) {
                        cll.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        ull.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        rll.add((CacheEntryRemovedListener)el);
                    }
                    if (el instanceof CacheEntryExpiredListener) {
                        ell.add((CacheEntryExpiredListener)el);
                    }
                    if (!(el instanceof CacheEntryEvictedListener)) continue;
                    evl.add((CacheEntryEvictedListener)el);
                }
                for (CacheEntryCreatedListener cacheEntryCreatedListener : cll) {
                    syncCreatedListeners.add(new AsyncCreatedListener(asyncDispatcher, cacheEntryCreatedListener));
                }
                for (CacheEntryUpdatedListener cacheEntryUpdatedListener : ull) {
                    syncUpdatedListeners.add(new AsyncUpdatedListener(asyncDispatcher, cacheEntryUpdatedListener));
                }
                for (CacheEntryRemovedListener cacheEntryRemovedListener : rll) {
                    syncRemovedListeners.add(new AsyncRemovedListener(asyncDispatcher, cacheEntryRemovedListener));
                }
                for (CacheEntryExpiredListener cacheEntryExpiredListener : ell) {
                    syncExpiredListeners.add(new AsyncExpiredListener(asyncDispatcher, cacheEntryExpiredListener));
                }
                for (CacheEntryEvictedListener cacheEntryEvictedListener : evl) {
                    syncEvictedListeners.add(new AsyncEvictedListener(asyncDispatcher, cacheEntryEvictedListener));
                }
            }
            if (!syncCreatedListeners.isEmpty()) {
                wc.syncEntryCreatedListeners = syncCreatedListeners.toArray(new CacheEntryCreatedListener[0]);
            }
            if (!syncUpdatedListeners.isEmpty()) {
                wc.syncEntryUpdatedListeners = syncUpdatedListeners.toArray(new CacheEntryUpdatedListener[0]);
            }
            if (!syncRemovedListeners.isEmpty()) {
                wc.syncEntryRemovedListeners = syncRemovedListeners.toArray(new CacheEntryRemovedListener[0]);
            }
            if (!syncExpiredListeners.isEmpty()) {
                wc.syncEntryExpiredListeners = syncExpiredListeners.toArray(new CacheEntryExpiredListener[0]);
            }
            if (!syncEvictedListeners.isEmpty()) {
                wc.syncEntryEvictedListeners = syncEvictedListeners.toArray(new CacheEntryEvictedListener[0]);
            }
            bc.eviction = EVICTION_FACTORY.constructEviction(this, bc, wc, this.config, Runtime.getRuntime().availableProcessors());
            Timing rh = Timing.of(this);
            bc.setTiming(rh);
            wc.init();
        } else {
            Timing rh = Timing.of(this);
            bc.setTiming(rh);
            bc.eviction = EVICTION_FACTORY.constructEviction(this, bc, HeapCacheListener.NO_OPERATION, this.config, Runtime.getRuntime().availableProcessors());
            bc.init();
        }
        if (this.config.hasLifecycleListeners()) {
            ArrayList<CacheClosedListener> closedListeners = new ArrayList<CacheClosedListener>();
            for (CustomizationSupplier sup : this.config.getLifecycleListeners()) {
                CacheLifecycleListener l = (CacheLifecycleListener)this.createCustomization(sup);
                if (l instanceof CacheClosedListener) {
                    closedListeners.add((CacheClosedListener)l);
                }
                if (!(l instanceof CacheCreatedListener)) continue;
                ((CacheCreatedListener)l).onCacheCreated(cache, (CacheBuildContext)this);
            }
            bc.cacheClosedListeners = closedListeners;
        }
        this.manager.sendCreatedEvent(cache, this);
        return cache;
    }

    private void checkConfiguration() {
        if (this.config.getExpireAfterWrite() == Cache2kConfig.EXPIRY_NOT_ETERNAL && this.config.getExpiryPolicy() == null) {
            throw new IllegalArgumentException("not eternal is set, but expire value is missing");
        }
    }

    private static class AsyncEvictedListener<K, V>
    implements CacheEntryEvictedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryEvictedListener<K, V> listener;

        AsyncEvictedListener(AsyncDispatcher<K> dispatcher, CacheEntryEvictedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void onEntryEvicted(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() throws Exception {
                    listener.onEntryEvicted(c, e);
                }
            });
        }
    }

    private static class AsyncExpiredListener<K, V>
    implements CacheEntryExpiredListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryExpiredListener<K, V> listener;

        AsyncExpiredListener(AsyncDispatcher<K> dispatcher, CacheEntryExpiredListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void onEntryExpired(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() throws Exception {
                    listener.onEntryExpired(c, e);
                }
            });
        }
    }

    private static class AsyncRemovedListener<K, V>
    implements CacheEntryRemovedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryRemovedListener<K, V> listener;

        AsyncRemovedListener(AsyncDispatcher<K> dispatcher, CacheEntryRemovedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void onEntryRemoved(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() throws Exception {
                    listener.onEntryRemoved(c, e);
                }
            });
        }
    }

    private static class AsyncUpdatedListener<K, V>
    implements CacheEntryUpdatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryUpdatedListener<K, V> listener;

        AsyncUpdatedListener(AsyncDispatcher<K> dispatcher, CacheEntryUpdatedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void onEntryUpdated(final Cache<K, V> cache, final CacheEntry<K, V> currentEntry, final CacheEntry<K, V> newEntry) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return currentEntry.getKey();
                }

                @Override
                public void execute() throws Exception {
                    listener.onEntryUpdated(cache, currentEntry, newEntry);
                }
            });
        }
    }

    static class AsyncCreatedListener<K, V>
    implements CacheEntryCreatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryCreatedListener<K, V> listener;

        AsyncCreatedListener(AsyncDispatcher<K> dispatcher, CacheEntryCreatedListener<K, V> listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void onEntryCreated(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() throws Exception {
                    listener.onEntryCreated(c, e);
                }
            });
        }
    }

    private static class WrappedAdvancedCacheLoader<K, V>
    implements AdvancedCacheLoader<K, V>,
    AutoCloseable {
        HeapCache<K, V> heapCache;
        private final AdvancedCacheLoader<K, V> forward;

        WrappedAdvancedCacheLoader(HeapCache<K, V> heapCache, AdvancedCacheLoader<K, V> forward) {
            this.heapCache = heapCache;
            this.forward = forward;
        }

        @Override
        public void close() throws Exception {
            if (this.forward instanceof AutoCloseable) {
                ((AutoCloseable)this.forward).close();
            }
        }

        public V load(K key, long startTime, CacheEntry<K, V> currentEntry) throws Exception {
            if (currentEntry == null || currentEntry.getExceptionInfo() != null) {
                return (V)this.forward.load(key, startTime, null);
            }
            return (V)this.forward.load(key, startTime, currentEntry);
        }
    }
}

