/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import org.cache2k.core.BaseCache;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.ExclusiveExecutor;
import org.cache2k.core.HeapCache;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.HealthInfoElement;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.eviction.EvictionMetrics;
import org.cache2k.core.util.Util;

class CacheBaseInfo
implements InternalCacheInfo {
    private final CommonMetrics metrics;
    private final HeapCache heapCache;
    private final InternalCache cache;
    private final long size;
    private final long infoCreatedTime;
    private int infoCreationDeltaMs;
    private final long missCnt;
    private final long hitCnt;
    private final long correctedPutCnt;
    private String extraStatistics;
    private final IntegrityState integrityState;
    private final long totalLoadCnt;
    private int loaderThreadsLimit = -1;
    private long asyncLoadsStarted = -1L;
    private long asyncLoadsInFlight = -1L;
    private int loaderThreadsMaxActive = -1;
    private long evictedWeight;
    private final long clearedTime;
    private final long newEntryCnt;
    private final long keyMutationCnt;
    private final long removedCnt;
    private final long clearRemovedCnt;
    private final long clearCnt;
    private final long expiredRemoveCnt;
    private final long evictedCnt;
    private final long maxSize;
    private final int evictionRunningCnt;
    private final long internalExceptionCnt;
    private final long maxWeight;
    private final long totalWeight;
    static final double EXPONENT_CONSTANT = -0.011;
    static final int SLOT_SIZE_MINIMUM = 5;

    CacheBaseInfo(HeapCache heapCache, InternalCache userCache, long now) {
        this.infoCreatedTime = now;
        this.cache = userCache;
        this.heapCache = heapCache;
        this.metrics = heapCache.metrics;
        EvictionMetrics em = heapCache.eviction.getMetrics();
        this.newEntryCnt = em.getNewEntryCount();
        this.expiredRemoveCnt = em.getExpiredRemovedCount();
        this.evictedCnt = em.getEvictedCount();
        this.maxSize = em.getMaxSize();
        this.maxWeight = em.getMaxWeight();
        this.totalWeight = em.getTotalWeight();
        this.evictedWeight = em.getEvictedWeight();
        this.clearedTime = heapCache.clearedTime;
        this.keyMutationCnt = heapCache.keyMutationCnt;
        this.removedCnt = em.getRemovedCount();
        this.clearRemovedCnt = heapCache.clearRemovedCnt;
        this.clearCnt = heapCache.clearCnt;
        this.internalExceptionCnt = heapCache.internalExceptionCnt;
        this.evictionRunningCnt = em.getEvictionRunningCount();
        this.integrityState = heapCache.getIntegrityState();
        this.extraStatistics = em.getExtraStatistics();
        if (this.extraStatistics.startsWith(", ")) {
            this.extraStatistics = this.extraStatistics.substring(2);
        }
        this.size = this.heapCache.getLocalSize();
        this.missCnt = this.metrics.getReadThroughCount() + this.metrics.getExplicitLoadCount() + this.metrics.getPeekHitNotFreshCount() + this.metrics.getPeekMissCount();
        this.hitCnt = em.getHitCount();
        this.correctedPutCnt = this.metrics.getPutNewEntryCount() + this.metrics.getPutHitCount();
        if (heapCache.loaderExecutor instanceof ExclusiveExecutor) {
            ThreadPoolExecutor ex = ((ExclusiveExecutor)heapCache.loaderExecutor).getThreadPoolExecutor();
            this.asyncLoadsInFlight = ex.getActiveCount();
            this.asyncLoadsStarted = ex.getTaskCount();
            this.loaderThreadsLimit = ex.getCorePoolSize();
            this.loaderThreadsMaxActive = ex.getLargestPoolSize();
        }
        this.totalLoadCnt = this.metrics.getReadThroughCount() + this.metrics.getExplicitLoadCount() + this.metrics.getRefreshCount();
    }

    String percentString(double d) {
        String s = Double.toString(d);
        return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
    }

    public void setInfoCreationDeltaMs(int millis) {
        this.infoCreationDeltaMs = millis;
    }

    @Override
    public String getName() {
        return this.heapCache.name;
    }

    @Override
    public String getImplementation() {
        return this.cache.getClass().getSimpleName();
    }

    @Override
    public long getExplicitLoadCount() {
        return this.metrics.getExplicitLoadCount();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getHeapCapacity() {
        return this.maxSize;
    }

    @Override
    public long getMaximumWeight() {
        return this.maxWeight;
    }

    @Override
    public long getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public long getEvictedWeight() {
        return this.evictedWeight;
    }

    @Override
    public long getGetCount() {
        return this.hitCnt + this.metrics.getPeekMissCount() + this.metrics.getReadThroughCount() - this.metrics.getHeapHitButNoReadCount();
    }

    @Override
    public long getMissCount() {
        return this.missCnt;
    }

    @Override
    public long getNewEntryCount() {
        return this.newEntryCnt;
    }

    @Override
    public long getHeapHitCount() {
        return this.hitCnt;
    }

    @Override
    public long getLoadCount() {
        return this.totalLoadCnt;
    }

    @Override
    public long getRefreshCount() {
        return this.metrics.getRefreshCount();
    }

    @Override
    public long getInternalExceptionCount() {
        return this.internalExceptionCnt;
    }

    @Override
    public long getRefreshRejectedCount() {
        return this.metrics.getRefreshRejectedCount();
    }

    @Override
    public long getSuppressedExceptionCount() {
        return this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.metrics.getLoadExceptionCount() + this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getRefreshedHitCount() {
        return this.metrics.getRefreshedHitCount();
    }

    @Override
    public long getExpiredCount() {
        return this.expiredRemoveCnt + this.metrics.getExpiredKeptCount();
    }

    @Override
    public long getEvictedCount() {
        return this.evictedCnt;
    }

    @Override
    public int getEvictionRunningCount() {
        return this.evictionRunningCnt;
    }

    @Override
    public long getRemoveCount() {
        return this.removedCnt;
    }

    @Override
    public long getPutCount() {
        return this.correctedPutCnt;
    }

    @Override
    public long getGoneSpinCount() {
        return this.metrics.getGoneSpinCount();
    }

    @Override
    public long getKeyMutationCount() {
        return this.keyMutationCnt;
    }

    @Override
    public long getTimerEventCount() {
        return this.metrics.getTimerEventCount();
    }

    @Override
    public double getHitRate() {
        long cnt = this.getGetCount();
        return cnt == 0L ? 0.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
    }

    @Override
    public String getHitRateString() {
        return this.percentString(this.getHitRate());
    }

    @Override
    public double getMillisPerLoad() {
        return this.getLoadCount() == 0L ? 0.0 : (double)this.metrics.getLoadMillis() * 1.0 / (double)this.getLoadCount();
    }

    @Override
    public long getLoadMillis() {
        return this.metrics.getLoadMillis();
    }

    @Override
    public String getIntegrityDescriptor() {
        return this.integrityState.getStateDescriptor();
    }

    @Override
    public long getStartedTime() {
        return this.heapCache.startedTime;
    }

    @Override
    public long getClearedTime() {
        return this.clearedTime;
    }

    @Override
    public long getInfoCreatedTime() {
        return this.infoCreatedTime;
    }

    @Override
    public int getInfoCreationDeltaMs() {
        return this.infoCreationDeltaMs;
    }

    @Override
    public Collection<HealthInfoElement> getHealth() {
        ArrayList<HealthInfoElement> l = new ArrayList<HealthInfoElement>();
        if (this.integrityState.getStateFlags() > 0L) {
            l.add(new HealthBean(this.cache, "integrity", "FAILURE", "Integrity check error: " + this.integrityState.getStateFlags()));
        }
        if (this.getKeyMutationCount() > 0L) {
            l.add(new HealthBean(this.cache, "keyMutation", "WARNING", "key mutation detected"));
        }
        if (this.getInternalExceptionCount() > 0L) {
            l.add(new HealthBean(this.cache, "internalException", "WARNING", "internal exception"));
        }
        return l;
    }

    @Override
    public long getAsyncLoadsStarted() {
        return this.asyncLoadsStarted;
    }

    @Override
    public long getAsyncLoadsInFlight() {
        return this.asyncLoadsInFlight;
    }

    @Override
    public int getLoaderThreadsLimit() {
        return this.loaderThreadsLimit;
    }

    @Override
    public int getLoaderThreadsMaxActive() {
        return this.loaderThreadsMaxActive;
    }

    @Override
    public String getExtraStatistics() {
        return this.extraStatistics;
    }

    private static String timestampToString(long t) {
        if (t == 0L) {
            return "-";
        }
        return Util.formatMillis(t);
    }

    @Override
    public long getClearCount() {
        return this.clearCnt;
    }

    @Override
    public long getClearedEntriesCount() {
        return this.clearRemovedCnt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache(");
        CacheManagerImpl cm = (CacheManagerImpl)this.cache.getCacheManager();
        sb.append("name=").append(BaseCache.nameQualifier(this.cache)).append(", ").append("size=").append(this.getSize()).append(", ");
        if (this.getHeapCapacity() >= 0L) {
            sb.append("capacity=").append(this.getHeapCapacity() != Long.MAX_VALUE ? Long.valueOf(this.getHeapCapacity()) : "unlimited").append(", ");
        } else {
            sb.append("maximumWeight=").append(this.getMaximumWeight() != Long.MAX_VALUE ? Long.valueOf(this.getMaximumWeight()) : "unlimited").append(", ");
            sb.append("currentWeight=").append(this.getTotalWeight()).append(", ");
        }
        sb.append("get=").append(this.getGetCount()).append(", ").append("miss=").append(this.getMissCount()).append(", ").append("put=").append(this.getPutCount()).append(", ").append("load=").append(this.getLoadCount()).append(", ").append("reload=").append(this.getExplicitLoadCount()).append(", ").append("heapHit=").append(this.getHeapHitCount()).append(", ").append("refresh=").append(this.getRefreshCount()).append(", ").append("refreshRejected=").append(this.getRefreshRejectedCount()).append(", ").append("refreshedHit=").append(this.getRefreshedHitCount()).append(", ").append("loadException=").append(this.getLoadExceptionCount()).append(", ").append("suppressedException=").append(this.getSuppressedExceptionCount()).append(", ").append("new=").append(this.getNewEntryCount()).append(", ").append("expire=").append(this.getExpiredCount()).append(", ").append("remove=").append(this.getRemoveCount()).append(", ").append("clear=").append(this.getClearCount()).append(", ").append("removeByClear=").append(this.getClearedEntriesCount()).append(", ").append("evict=").append(this.getEvictedCount()).append(", ").append("timer=").append(this.getTimerEventCount()).append(", ").append("goneSpin=").append(this.getGoneSpinCount()).append(", ").append("hitRate=").append(this.getHitRateString()).append(", ").append("msecs/load=").append(CacheBaseInfo.formatMillisPerLoad(this.getMillisPerLoad())).append(", ").append("asyncLoadsStarted=").append(this.asyncLoadsStarted).append(", ").append("asyncLoadsInFlight=").append(this.asyncLoadsInFlight).append(", ").append("loaderThreadsLimit=").append(this.loaderThreadsLimit).append(", ").append("loaderThreadsMaxActive=").append(this.loaderThreadsMaxActive).append(", ").append("created=").append(CacheBaseInfo.timestampToString(this.getStartedTime())).append(", ").append("cleared=").append(CacheBaseInfo.timestampToString(this.getClearedTime())).append(", ").append("infoCreated=").append(CacheBaseInfo.timestampToString(this.getInfoCreatedTime())).append(", ").append("infoCreationDeltaMs=").append(this.getInfoCreationDeltaMs()).append(", ").append("impl=").append(this.getImplementation()).append(", ").append(this.getExtraStatistics()).append(", ").append("evictionRunning=").append(this.getEvictionRunningCount()).append(", ").append("keyMutation=").append(this.getKeyMutationCount()).append(", ").append("internalException=").append(this.getInternalExceptionCount()).append(", ").append("integrityState=").append(this.getIntegrityDescriptor()).append(", ").append("version=").append(cm.getProvider().getVersion());
        sb.append(")");
        return sb.toString();
    }

    static String formatMillisPerLoad(double val) {
        if (val < 0.0) {
            return "-";
        }
        DecimalFormat f = new DecimalFormat("#.###");
        return f.format(val);
    }

    static int hashQuality(int noCollisionPercent, int longestSlot) {
        if (longestSlot == 0) {
            return 100;
        }
        int correctionForOversizeSlot = (int)((1.0 - Math.exp(-0.011 * (double)Math.max(0, longestSlot - 5))) * 100.0);
        int quality = noCollisionPercent - correctionForOversizeSlot;
        return Math.max(0, Math.min(100, quality));
    }

    static class HealthBean
    implements HealthInfoElement {
        String id;
        String message;
        String level;
        InternalCache cache;

        HealthBean(InternalCache cache, String id, String level, String message) {
            this.cache = cache;
            this.id = id;
            this.level = level;
            this.message = message;
        }

        @Override
        public InternalCache getCache() {
            return this.cache;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

