/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationWithSections;
import org.cache2k.configuration.SingletonConfigurationSection;
import org.cache2k.configuration.ValidatingConfigurationBean;
import org.cache2k.impl.xmlConfiguration.ConfigurationContext;
import org.cache2k.impl.xmlConfiguration.generic.BeanPropertyMutator;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.generic.ParsedConfiguration;
import org.cache2k.impl.xmlConfiguration.generic.PropertyParser;
import org.cache2k.impl.xmlConfiguration.generic.SourceLocation;
import org.cache2k.impl.xmlConfiguration.generic.StandardPropertyParser;

public class ConfigurationProvider {
    private final PropertyParser propertyParser = new StandardPropertyParser();
    private volatile Map<Class<?>, BeanPropertyMutator> type2mutator = new HashMap();

    private static String constructGetterName(String containerName) {
        return "get" + Character.toUpperCase(containerName.charAt(0)) + containerName.substring(1);
    }

    void apply(ConfigurationContext ctx, ParsedConfiguration parsedCfg, Object cfg) {
        ParsedConfiguration templates = ctx.getTemplates();
        ConfigurationTokenizer.Property include = parsedCfg.getPropertyMap().get("include");
        if (include != null) {
            for (String template : include.getValue().split(",")) {
                ParsedConfiguration c2 = null;
                if (templates != null) {
                    c2 = templates.getSection(template);
                }
                if (c2 == null) {
                    throw new ConfigurationException("Template not found '" + template + "'", include);
                }
                this.apply(ctx, c2, cfg);
            }
        }
        this.applyPropertyValues(parsedCfg, cfg);
        if (!(cfg instanceof ConfigurationWithSections)) {
            return;
        }
        ConfigurationWithSections configurationWithSections = (ConfigurationWithSections)cfg;
        for (ParsedConfiguration parsedSection : parsedCfg.getSections()) {
            Class<?> type;
            String sectionType = ctx.getPredefinedSectionTypes().get(parsedSection.getName());
            if (sectionType == null) {
                sectionType = parsedSection.getType();
            }
            if (sectionType == null) {
                throw new ConfigurationException("type missing or unknown", parsedSection);
            }
            try {
                type = Class.forName(sectionType);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("class not found '" + sectionType + "'", parsedSection);
            }
            if (this.handleSection(ctx, type, configurationWithSections, parsedSection) || this.handleCollection(ctx, type, cfg, parsedSection) || this.handleBean(ctx, type, cfg, parsedSection)) continue;
            throw new ConfigurationException("Unknown property  '" + parsedSection.getContainer() + "'", parsedSection);
        }
    }

    private boolean handleBean(ConfigurationContext ctx, Class<?> type, Object cfg, ParsedConfiguration parsedCfg) {
        String containerName = parsedCfg.getContainer();
        BeanPropertyMutator m = this.provideMutator(cfg.getClass());
        Class<?> targetType = m.getType(containerName);
        if (targetType == null) {
            return false;
        }
        if (!targetType.isAssignableFrom(type)) {
            throw new ConfigurationException("Type mismatch, expected: '" + targetType.getName() + "'", parsedCfg);
        }
        Object bean = this.createBeanAndApplyConfiguration(ctx, type, parsedCfg);
        this.mutateAndCatch(cfg, m, containerName, bean, parsedCfg, bean);
        return true;
    }

    private boolean handleCollection(ConfigurationContext ctx, Class<?> type, Object cfg, ParsedConfiguration parsedCfg) {
        Collection c;
        Method m;
        String containerName = parsedCfg.getContainer();
        try {
            m = cfg.getClass().getMethod(ConfigurationProvider.constructGetterName(containerName), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        if (!Collection.class.isAssignableFrom(m.getReturnType())) {
            return false;
        }
        try {
            c = (Collection)m.invoke(cfg, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot access collection for '" + containerName + "' " + ex, parsedCfg);
        }
        Object bean = this.createBeanAndApplyConfiguration(ctx, type, parsedCfg);
        try {
            c.add(bean);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Rejected add '" + containerName + "': " + ex.getMessage(), parsedCfg);
        }
        return true;
    }

    private Object createBeanAndApplyConfiguration(ConfigurationContext ctx, Class<?> type, ParsedConfiguration parsedCfg) {
        Object bean;
        try {
            bean = type.newInstance();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot instantiate bean: " + ex, parsedCfg);
        }
        ParsedConfiguration parameters = parsedCfg.getSection("parameters");
        this.apply(ctx, parameters != null ? parameters : parsedCfg, bean);
        if (bean instanceof ValidatingConfigurationBean) {
            try {
                ((ValidatingConfigurationBean)bean).validate();
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Validation error '" + bean.getClass().getSimpleName() + "': " + ex.getMessage(), parsedCfg);
            }
        }
        return bean;
    }

    private boolean handleSection(ConfigurationContext ctx, Class<?> type, ConfigurationWithSections cfg, ParsedConfiguration sc) {
        String containerName = sc.getContainer();
        if (!"sections".equals(containerName)) {
            return false;
        }
        ConfigurationSection sectionBean = cfg.getSections().getSection(type);
        if (!(sectionBean instanceof SingletonConfigurationSection)) {
            try {
                sectionBean = (ConfigurationSection)type.newInstance();
            }
            catch (Exception ex) {
                throw new ConfigurationException("Cannot instantiate section class: " + ex, sc);
            }
            cfg.getSections().add(sectionBean);
        }
        this.apply(ctx, sc, sectionBean);
        return true;
    }

    private void applyPropertyValues(ParsedConfiguration cfg, Object bean) {
        BeanPropertyMutator m = this.provideMutator(bean.getClass());
        for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
            Object obj;
            Class<?> propertyType = m.getType(p.getName());
            if (propertyType == null) {
                if ("include".equals(p.getName()) || "name".equals(p.getName()) || "type".equals(p.getName())) continue;
                throw new ConfigurationException("Unknown property '" + p.getName() + "'", p);
            }
            try {
                obj = this.propertyParser.parse(propertyType, p.getValue());
            }
            catch (Exception ex) {
                if (ex instanceof NumberFormatException) {
                    throw new ConfigurationException("Cannot parse number: '" + p.getValue() + "'", p);
                }
                if (ex instanceof IllegalArgumentException) {
                    throw new ConfigurationException("Value '" + p.getValue() + "' parse error: " + ex.getMessage(), p);
                }
                throw new ConfigurationException("Cannot parse property: " + ex, p);
            }
            this.mutateAndCatch(bean, m, p, obj);
        }
    }

    private void mutateAndCatch(Object cfg, BeanPropertyMutator m, ConfigurationTokenizer.Property p, Object obj) {
        this.mutateAndCatch(cfg, m, p.getName(), p.getValue(), p, obj);
    }

    private void mutateAndCatch(Object cfg, BeanPropertyMutator m, String name, Object valueForExceptionText, SourceLocation loc, Object obj) {
        try {
            m.mutate(cfg, name, obj);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IllegalArgumentException) {
                throw new ConfigurationException("Value '" + valueForExceptionText + "' rejected: " + t.getMessage(), loc);
            }
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanPropertyMutator provideMutator(Class<?> type) {
        BeanPropertyMutator m = this.type2mutator.get(type);
        if (m == null) {
            ConfigurationProvider configurationProvider = this;
            synchronized (configurationProvider) {
                m = new BeanPropertyMutator(type);
                HashMap m2 = new HashMap(this.type2mutator);
                m2.put(type, m);
                this.type2mutator = m2;
            }
        }
        return m;
    }
}

