/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.cache2k.core.util.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Log {
    private static final Map<String, Log> LOGGERS = new HashMap<String, Log>();
    private static final LogFactory LOG_FACTORY = Log.initializeLogFactory();

    public static Log getLog(Class<?> type) {
        return Log.getLog(type.getName());
    }

    public static synchronized Log getLog(String s) {
        Log l = LOGGERS.get(s);
        if (l != null) {
            return l;
        }
        if (LOG_FACTORY == null) {
            Log.initializeLogFactory();
        }
        l = LOG_FACTORY.getLog(s);
        LOGGERS.put(s, l);
        return l;
    }

    private static LogFactory initializeLogFactory() {
        ServiceLoader<LogFactory> loader = ServiceLoader.load(LogFactory.class);
        Iterator<LogFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            LogFactory lf = iterator.next();
            return lf;
        }
        try {
            final ILoggerFactory lf = LoggerFactory.getILoggerFactory();
            return new LogFactory(){

                @Override
                public Log getLog(String s) {
                    return new Slf4jLogger(lf.getLogger(s));
                }
            };
        }
        catch (NoClassDefFoundError lf) {
            try {
                final org.apache.commons.logging.LogFactory cl = org.apache.commons.logging.LogFactory.getFactory();
                return new LogFactory(){

                    @Override
                    public Log getLog(String s) {
                        return new CommonsLogger(cl.getInstance(s));
                    }
                };
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return new LogFactory(){

                    @Override
                    public Log getLog(String s) {
                        return new JdkLogger(java.util.logging.Logger.getLogger(s));
                    }
                };
            }
        }
    }

    public static synchronized void registerSuppression(String s, Log l) {
        LOGGERS.put(s, l);
    }

    public static synchronized void deregisterSuppression(String s) {
        LOGGERS.remove(s);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    static {
        Log log = Log.getLog(Log.class.getName());
        log.debug("Using " + log.getClass().getSimpleName());
    }

    public static class SuppressionCounter
    extends Log {
        AtomicInteger debugCount = new AtomicInteger();
        AtomicInteger infoCount = new AtomicInteger();
        AtomicInteger warnCount = new AtomicInteger();

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public void debug(String s) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void info(String s, Throwable ex) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void info(String s) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void warn(String s) {
            this.warnCount.incrementAndGet();
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.warnCount.incrementAndGet();
        }

        public int getDebugCount() {
            return this.debugCount.get();
        }

        public int getInfoCount() {
            return this.infoCount.get();
        }

        public int getWarnCount() {
            return this.warnCount.get();
        }
    }

    private static class JdkLogger
    extends Log {
        java.util.logging.Logger logger;

        private JdkLogger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void debug(String s) {
            this.logger.logp(Level.FINE, null, null, s);
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.logger.logp(Level.FINE, s, null, null, ex);
        }

        @Override
        public void info(String s) {
            this.logger.logp(Level.INFO, null, null, s);
        }

        @Override
        public void info(String s, Throwable ex) {
            this.logger.logp(Level.INFO, null, null, s, ex);
        }

        @Override
        public void warn(String s) {
            this.logger.logp(Level.WARNING, null, null, s);
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.logger.logp(Level.WARNING, null, null, s, ex);
        }
    }

    private static class Slf4jLogger
    extends Log {
        Logger logger;

        private Slf4jLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void debug(String s) {
            this.logger.debug(s);
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.logger.debug(s, ex);
        }

        @Override
        public void info(String s, Throwable ex) {
            this.logger.info(s);
        }

        @Override
        public void info(String s) {
            this.logger.info(s);
        }

        @Override
        public void warn(String s) {
            this.logger.warn(s);
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.logger.warn(s, ex);
        }
    }

    private static class CommonsLogger
    extends Log {
        org.apache.commons.logging.Log cLog;

        private CommonsLogger(org.apache.commons.logging.Log cLog) {
            this.cLog = cLog;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.cLog.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.cLog.isInfoEnabled();
        }

        @Override
        public void debug(String s) {
            this.cLog.debug((Object)s);
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.cLog.debug((Object)s, ex);
        }

        @Override
        public void info(String s, Throwable ex) {
            this.cLog.info((Object)s);
        }

        @Override
        public void info(String s) {
            this.cLog.info((Object)s);
        }

        @Override
        public void warn(String s) {
            this.cLog.warn((Object)s);
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.cLog.warn((Object)s, ex);
        }
    }
}

