/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheBuildContext;
import org.cache2k.core.CacheCloseContext;
import org.cache2k.core.Entry;
import org.cache2k.core.timing.DynamicTiming;
import org.cache2k.core.timing.StaticTiming;
import org.cache2k.core.timing.TimeAgnosticTiming;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.core.util.Util;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.expiry.ValueWithExpiryTime;
import org.cache2k.integration.ExceptionInformation;

public abstract class Timing<K, V> {
    static final ExpiryPolicy<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new ExpiryPolicy<Object, ValueWithExpiryTime>(){

        public long calculateExpiryTime(Object key, ValueWithExpiryTime value, long loadTime, CacheEntry<Object, ValueWithExpiryTime> oldEntry) {
            return value.getCacheExpiryTime();
        }
    };

    static boolean realDuration(long t) {
        return t > 0L && t < Long.MAX_VALUE;
    }

    static boolean zeroOrUnspecified(long t) {
        return t == 0L || t == -1L;
    }

    public static <K, V> Timing<K, V> of(CacheBuildContext<K, V> buildContext) {
        Cache2kConfiguration<K, V> cfg = buildContext.getConfiguration();
        if (cfg.getExpireAfterWrite() == 0L && Timing.zeroOrUnspecified(cfg.getRetryInterval())) {
            return TimeAgnosticTiming.IMMEDIATE;
        }
        if (cfg.getExpiryPolicy() != null || cfg.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) || cfg.getResiliencePolicy() != null) {
            DynamicTiming<K, V> h = new DynamicTiming<K, V>(buildContext);
            return h;
        }
        if (cfg.getResilienceDuration() > 0L && !cfg.isSuppressExceptions()) {
            throw new IllegalArgumentException("Ambiguous: exceptions suppression is switched off, but resilience duration is specified");
        }
        if (Timing.realDuration(cfg.getExpireAfterWrite()) || Timing.realDuration(cfg.getRetryInterval()) || Timing.realDuration(cfg.getResilienceDuration())) {
            StaticTiming<K, V> h = new StaticTiming<K, V>(buildContext);
            return h;
        }
        if (cfg.getExpireAfterWrite() == Long.MAX_VALUE || cfg.getExpireAfterWrite() == -1L) {
            if (Timing.zeroOrUnspecified(cfg.getRetryInterval())) {
                return TimeAgnosticTiming.ETERNAL_IMMEDIATE;
            }
            if (cfg.getRetryInterval() == Long.MAX_VALUE) {
                return TimeAgnosticTiming.ETERNAL;
            }
        }
        throw new IllegalArgumentException("expiry time ambiguous");
    }

    public void setTarget(TimerEventListener<K, V> c) {
    }

    public void cancelAll() {
    }

    public void close(CacheCloseContext closeContext) {
    }

    public abstract long calculateNextRefreshTime(Entry<K, V> var1, V var2, long var3);

    public abstract long suppressExceptionUntil(Entry<K, V> var1, ExceptionInformation var2);

    public abstract long cacheExceptionUntil(Entry<K, V> var1, ExceptionInformation var2);

    public long stopStartTimer(long expiryTime, Entry<K, V> e) {
        if (expiryTime > 0L && expiryTime < Long.MAX_VALUE || expiryTime < 0L) {
            throw new IllegalArgumentException("Cache is not configured for variable expiry: " + Util.formatMillis(expiryTime));
        }
        return expiryTime == 0L ? 4L : expiryTime;
    }

    public boolean startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        return true;
    }

    public void cancelExpiryTimer(Entry<K, V> e) {
    }

    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
    }
}

