/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheBuildContext;
import org.cache2k.core.CacheCloseContext;
import org.cache2k.core.DefaultResiliencePolicy;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.timing.DefaultTimer;
import org.cache2k.core.timing.Tasks;
import org.cache2k.core.timing.Timer;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.core.timing.Timing;
import org.cache2k.core.util.InternalClock;
import org.cache2k.expiry.Expiry;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ResiliencePolicy;

public class StaticTiming<K, V>
extends Timing<K, V> {
    static final long SAFETY_GAP_MILLIS = HeapCache.TUNABLE.sharpExpirySafetyGapMillis;
    protected final ResiliencePolicy<K, V> resiliencePolicy;
    protected final InternalClock clock;
    protected final boolean sharpExpiry;
    protected final boolean refreshAhead;
    protected final long expiryMillis;
    protected final long lagMillis;
    private Timer timer;
    private TimerEventListener<K, V> target;

    StaticTiming(CacheBuildContext<K, V> buildContext) {
        this.clock = buildContext.getClock();
        Cache2kConfiguration<K, V> c = buildContext.getConfiguration();
        long expiryMillis = c.getExpireAfterWrite();
        this.expiryMillis = expiryMillis == Long.MAX_VALUE || expiryMillis < 0L ? Long.MAX_VALUE : expiryMillis;
        this.refreshAhead = c.isRefreshAhead();
        this.sharpExpiry = c.isSharpExpiry();
        long lagMillisTmp = c.getTimerLag();
        this.lagMillis = lagMillisTmp == -1L ? HeapCache.TUNABLE.timerLagMillis : lagMillisTmp;
        this.timer = new DefaultTimer(this.clock, this.lagMillis);
        this.resiliencePolicy = this.provideResiliencePolicy(buildContext);
    }

    ResiliencePolicy<K, V> provideResiliencePolicy(CacheBuildContext<K, V> buildContext) {
        Cache2kConfiguration<K, V> c = buildContext.getConfiguration();
        final long expireAfterWriteMillis = c.getExpireAfterWrite();
        final long resilienceDuration = c.getResilienceDuration();
        final boolean suppressException = c.isSuppressExceptions();
        final long retryInterval = c.getRetryInterval();
        final long maxRetryInterval = c.getMaxRetryInterval();
        ResiliencePolicy.Context ctx = new ResiliencePolicy.Context(){

            public long getExpireAfterWriteMillis() {
                return expireAfterWriteMillis;
            }

            public long getResilienceDurationMillis() {
                return suppressException ? resilienceDuration : 0L;
            }

            public long getRetryIntervalMillis() {
                return retryInterval;
            }

            public long getMaxRetryIntervalMillis() {
                return maxRetryInterval;
            }
        };
        DefaultResiliencePolicy policy = (DefaultResiliencePolicy)((Object)buildContext.createCustomization(c.getResiliencePolicy()));
        if (policy == null) {
            policy = new DefaultResiliencePolicy();
        }
        policy.init(ctx);
        return policy;
    }

    @Override
    public void setTarget(TimerEventListener<K, V> target) {
        this.target = target;
    }

    @Override
    public void cancelAll() {
        Timer timer = this.timer;
        if (timer != null) {
            timer.cancelAll();
        }
    }

    @Override
    public void close(CacheCloseContext closeContext) {
        Timer timer = this.timer;
        if (timer != null) {
            timer.cancelAll();
            closeContext.closeCustomization(this.resiliencePolicy, "resiliencePolicy");
        }
        this.timer = null;
    }

    @Override
    public long calculateNextRefreshTime(Entry<K, V> e, V v, long loadTime) {
        return StaticTiming.calcNextRefreshTime(e.getKey(), v, loadTime, e, null, this.expiryMillis, this.sharpExpiry);
    }

    @Override
    public long suppressExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
        return this.resiliencePolicy.suppressExceptionUntil(e.getKey(), inf, e.getTempCacheEntry());
    }

    @Override
    public long cacheExceptionUntil(Entry<K, V> e, ExceptionInformation inf) {
        return this.resiliencePolicy.retryLoadAfter(e.getKey(), inf);
    }

    long expiredEventuallyStartBackgroundRefresh(Entry<K, V> e, boolean sharpExpiry) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
            this.scheduleTask(0L, e);
            return sharpExpiry ? 5L : 16L;
        }
        return 4L;
    }

    @Override
    public long stopStartTimer(long expiryTime, Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        if (expiryTime == 0L) {
            return 4L;
        }
        if (expiryTime == -1L) {
            long nrt = e.getNextRefreshTime();
            if (nrt == 0L) {
                throw new IllegalArgumentException("neutral expiry not allowed for creation");
            }
            return e.getNextRefreshTime();
        }
        if (expiryTime == Long.MAX_VALUE) {
            return expiryTime;
        }
        if (expiryTime == 1L) {
            return this.expiredEventuallyStartBackgroundRefresh(e, false);
        }
        long now = this.clock.millis();
        if (Math.abs(expiryTime) <= now) {
            return this.expiredEventuallyStartBackgroundRefresh(e, expiryTime < 0L);
        }
        if (expiryTime < 0L) {
            long timerTime = -expiryTime - SAFETY_GAP_MILLIS - this.timer.getLagMillis();
            if (timerTime >= now) {
                e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
                this.scheduleTask(timerTime, e);
                expiryTime = -expiryTime;
            } else {
                this.scheduleFinalExpireWithOptionalRefresh(e, -expiryTime);
            }
        } else {
            this.scheduleFinalExpireWithOptionalRefresh(e, expiryTime);
        }
        return expiryTime;
    }

    @Override
    public boolean startRefreshProbationTimer(Entry<K, V> e, long nextRefreshTime) {
        this.cancelExpiryTimer(e);
        if (nextRefreshTime == Long.MAX_VALUE) {
            e.setNextRefreshTime(nextRefreshTime);
            return false;
        }
        if (nextRefreshTime > 0L && nextRefreshTime < 32L) {
            e.setNextRefreshTime(4L);
            return true;
        }
        long absTime = Math.abs(nextRefreshTime);
        e.setRefreshProbationNextRefreshTime(absTime);
        e.setNextRefreshTime(6L);
        e.setTask(new Tasks.RefreshExpireTimerTask<K, V>().to(this.target, e));
        this.scheduleTask(absTime, e);
        return false;
    }

    @Override
    public void scheduleFinalTimerForSharpExpiry(Entry<K, V> e) {
        this.cancelExpiryTimer(e);
        this.scheduleFinalExpireWithOptionalRefresh(e, e.getNextRefreshTime());
    }

    void scheduleFinalExpireWithOptionalRefresh(Entry<K, V> e, long t) {
        if (this.refreshAhead) {
            e.setTask(new Tasks.RefreshTimerTask<K, V>().to(this.target, e));
        } else {
            e.setTask(new Tasks.ExpireTimerTask<K, V>().to(this.target, e));
        }
        this.scheduleTask(t, e);
    }

    void scheduleTask(long nextRefreshTime, Entry<K, V> e) {
        Timer timer = this.timer;
        if (timer != null) {
            try {
                timer.schedule(e.getTask(), nextRefreshTime);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancelExpiryTimer(Entry<K, V> e) {
        Tasks tsk = (Tasks)e.getTask();
        Timer timer = this.timer;
        if (tsk != null && timer != null) {
            timer.cancel(tsk);
        }
        e.setTask(null);
    }

    static <K, V> long calcNextRefreshTime(K key, V newValue, long now, CacheEntry<K, V> entry, ExpiryPolicy<K, V> policy, long maxLinger, boolean sharpExpiryEnabled) {
        long t;
        if (maxLinger == 0L) {
            return 0L;
        }
        if (policy != null) {
            long t2 = policy.calculateExpiryTime(key, newValue, now, entry);
            return StaticTiming.limitExpiryToMaxLinger(now, maxLinger, t2, sharpExpiryEnabled);
        }
        if (maxLinger < Long.MAX_VALUE && (t = maxLinger + now) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    static long limitExpiryToMaxLinger(long now, long maxLinger, long requestedExpiryTime, boolean sharpExpiryEnabled) {
        if (sharpExpiryEnabled && requestedExpiryTime > 1L && requestedExpiryTime < Long.MAX_VALUE) {
            requestedExpiryTime = -requestedExpiryTime;
        }
        return Expiry.mixTimeSpanAndPointInTime((long)now, (long)maxLinger, (long)requestedExpiryTime);
    }
}

