/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.cache2k.core.HeapCache;
import org.cache2k.core.timing.Scheduler;

public class DefaultScheduler
implements Scheduler {
    public static final Scheduler INSTANCE = new DefaultScheduler();
    private Executor pooledExecutor = HeapCache.SHARED_EXECUTOR;
    private ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(2, new DaemonThreadFactory());

    private DefaultScheduler() {
    }

    @Override
    public void schedule(final Runnable task, long millis) {
        Runnable wrap = new Runnable(){

            @Override
            public void run() {
                DefaultScheduler.this.pooledExecutor.execute(task);
            }
        };
        long delay = millis - System.currentTimeMillis();
        delay = Math.max(0L, delay);
        this.scheduledExecutor.schedule(wrap, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void execute(Runnable command) {
        this.pooledExecutor.execute(command);
    }

    static final class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("cache2k-scheduler");
            t.setPriority(10);
            return t;
        }
    }
}

