/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CacheEntry;
import org.cache2k.core.Entry;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ExceptionPropagator;

public class ExceptionWrapper<K>
implements ExceptionInformation,
CacheEntry<K, Void> {
    private final Throwable exception;
    private final long loadTime;
    private final int count;
    private final long since;
    private final K key;
    private final ExceptionPropagator<K> propagator;
    private final long until;

    public ExceptionWrapper(ExceptionWrapper<K> w, long until) {
        this.exception = w.exception;
        this.loadTime = w.loadTime;
        this.count = w.count;
        this.since = w.since;
        this.key = w.key;
        this.propagator = w.propagator;
        this.until = until;
    }

    public ExceptionWrapper(K key, long now, Throwable ex, ExceptionPropagator<K> p) {
        this.key = key;
        this.loadTime = this.since = now;
        this.exception = ex;
        this.propagator = p;
        this.until = 0L;
        this.count = 0;
    }

    public ExceptionWrapper(K key, Throwable exception, long loadTime, Entry e, ExceptionPropagator<K> p) {
        this(key, exception, loadTime, e.getValueOrException() instanceof ExceptionWrapper ? (ExceptionInformation)e.getValueOrException() : e.getSuppressedLoadExceptionInformation(), p);
    }

    public ExceptionWrapper(K key, Throwable exception, long loadTime, ExceptionInformation w, ExceptionPropagator<K> p) {
        this.propagator = p;
        this.exception = exception;
        this.key = key;
        this.loadTime = loadTime;
        if (w != null) {
            this.since = w.getSinceTime();
            this.count = w.getRetryCount() + 1;
        } else {
            this.since = this.loadTime;
            this.count = 0;
        }
        this.until = 0L;
    }

    public K getKey() {
        return this.key;
    }

    public Void getValue() {
        this.propagateException();
        return null;
    }

    public long getLastModification() {
        throw new UnsupportedOperationException();
    }

    public ExceptionPropagator getExceptionPropagator() {
        return this.propagator;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getUntil() {
        return this.until;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public int getRetryCount() {
        return this.count;
    }

    public long getSinceTime() {
        return this.since;
    }

    public void propagateException() {
        throw this.getExceptionPropagator().propagateException(this.key, (ExceptionInformation)this);
    }

    public String toString() {
        return "ExceptionWrapper{key=" + this.getKey() + ", exception=" + this.exception + "}";
    }
}

