/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.DummyConfigurationProvider;
import org.cache2k.core.InternalCache2kBuilder;
import org.cache2k.core.spi.CacheConfigurationProvider;
import org.cache2k.core.util.Cache2kVersion;
import org.cache2k.core.util.Log;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.Cache2kExtensionProvider;
import org.cache2k.spi.SingleProviderResolver;

public class Cache2kCoreProviderImpl
implements Cache2kCoreProvider {
    public static final CacheConfigurationProvider CACHE_CONFIGURATION_PROVIDER = TunableFactory.get(Tunable.class).enableExternalConfiguration ? (CacheConfigurationProvider)SingleProviderResolver.resolve(CacheConfigurationProvider.class, DummyConfigurationProvider.class) : new DummyConfigurationProvider();
    private final Object lock = new Object();
    private volatile Map<ClassLoader, String> loader2defaultName = Collections.emptyMap();
    private volatile Map<ClassLoader, Map<String, CacheManager>> loader2name2manager = Collections.emptyMap();
    private String version;

    public Cache2kCoreProviderImpl() {
        this.extractVersionAndGreet();
        this.registerExtensions();
    }

    private void extractVersionAndGreet() {
        Log log = Log.getLog(this.getClass());
        this.version = Cache2kVersion.getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("cache2k starting. ");
        sb.append("version=");
        sb.append(this.version);
        log.info(sb.toString());
        String message = TunableFactory.get(Tunable.class).message;
        if (message != null) {
            log.info(message);
        }
    }

    private void registerExtensions() {
        Iterator<Cache2kExtensionProvider> it = ServiceLoader.load(Cache2kExtensionProvider.class, CacheManager.class.getClassLoader()).iterator();
        while (it.hasNext()) {
            try {
                it.next().registerCache2kExtension();
            }
            catch (ServiceConfigurationError ex) {
                Log.getLog(CacheManager.class.getName()).debug("Error loading cache2k extension", ex);
            }
        }
    }

    public Object getLockObject() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultManagerName(ClassLoader cl, String s) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.loader2defaultName.containsKey(cl)) {
                throw new IllegalStateException("a CacheManager was already created");
            }
            this.replaceDefaultName(cl, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultManagerName(ClassLoader cl) {
        String n = this.loader2defaultName.get(cl);
        if (n != null) {
            return n;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            n = CACHE_CONFIGURATION_PROVIDER.getDefaultManagerName(cl);
            if (n == null) {
                n = "default";
            }
            this.replaceDefaultName(cl, n);
        }
        return n;
    }

    private void replaceDefaultName(ClassLoader cl, String s) {
        WeakHashMap<ClassLoader, String> copy = new WeakHashMap<ClassLoader, String>(this.loader2defaultName);
        copy.put(cl, s);
        this.loader2defaultName = copy;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public CacheManager getManager(ClassLoader cl, String name) {
        CacheManagerImpl.checkName(name);
        if (cl == null) {
            throw new NullPointerException("classloader is null");
        }
        return this.getManager(cl, name, this.getDefaultManagerName(cl).equals(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getManager(ClassLoader cl, String name, boolean defaultFallback) {
        CacheManager mgr;
        Map<String, CacheManager> loader2managers = this.loader2name2manager.get(cl);
        if (loader2managers != null && (mgr = loader2managers.get(name)) != null) {
            return mgr;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            loader2managers = this.loader2name2manager.get(cl);
            if (loader2managers != null && (mgr = loader2managers.get(name)) != null) {
                return mgr;
            }
            loader2managers = loader2managers != null ? new HashMap<String, CacheManager>(loader2managers) : new HashMap<String, CacheManager>();
            mgr = new CacheManagerImpl(this, cl, name, defaultFallback);
            loader2managers.put(name, mgr);
            WeakHashMap<ClassLoader, Map<String, CacheManager>> copy = new WeakHashMap<ClassLoader, Map<String, CacheManager>>(this.loader2name2manager);
            copy.put(cl, loader2managers);
            this.loader2name2manager = copy;
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManager(CacheManager cm) {
        Object object = this.getLockObject();
        synchronized (object) {
            Map<String, CacheManager> name2managers = this.loader2name2manager.get(cm.getClassLoader());
            name2managers = new HashMap<String, CacheManager>(name2managers);
            CacheManager removed = name2managers.remove(cm.getName());
            WeakHashMap<ClassLoader, Map<String, CacheManager>> copy = new WeakHashMap<ClassLoader, Map<String, CacheManager>>(this.loader2name2manager);
            copy.put(cm.getClassLoader(), name2managers);
            this.loader2name2manager = copy;
            if (cm.isDefaultManager()) {
                WeakHashMap<ClassLoader, String> defaultNameCopy = new WeakHashMap<ClassLoader, String>(this.loader2defaultName);
                defaultNameCopy.remove(cm.getClassLoader());
                this.loader2defaultName = defaultNameCopy;
            }
        }
    }

    public void close(ClassLoader l) {
        for (CacheManager cm : this.loader2name2manager.get(l).values()) {
            cm.close();
        }
    }

    public void close() {
        for (ClassLoader cl : this.loader2name2manager.keySet()) {
            this.close(cl);
        }
    }

    public void close(ClassLoader cl, String managerName) {
        Map<String, CacheManager> map;
        if (cl == null) {
            cl = this.getDefaultClassLoader();
        }
        if ((map = this.loader2name2manager.get(cl)) == null) {
            return;
        }
        CacheManager cm = map.get(managerName);
        if (cm == null) {
            return;
        }
        cm.close();
    }

    public <K, V> Cache<K, V> createCache(CacheManager m, Cache2kConfiguration<K, V> cfg) {
        return new InternalCache2kBuilder<K, V>(cfg, m).build();
    }

    public String getVersion() {
        return this.version;
    }

    public Cache2kConfiguration getDefaultConfiguration(CacheManager mgr) {
        return CACHE_CONFIGURATION_PROVIDER.getDefaultConfiguration(mgr);
    }

    public static class Tunable
    extends TunableConstants {
        public boolean enableExternalConfiguration = true;
        public String message = null;
    }
}

